/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.graylog2.GelfAMQPSender;
import org.graylog2.GelfMessage;
import org.graylog2.GelfMessageFactory;
import org.graylog2.GelfMessageProvider;
import org.graylog2.GelfSender;
import org.graylog2.GelfSenderResult;
import org.graylog2.GelfTCPSender;
import org.graylog2.GelfUDPSender;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfAppender
extends AppenderSkeleton
implements GelfMessageProvider {
    private String graylogHost;
    private String amqpURI;
    private String amqpExchangeName;
    private String amqpRoutingKey;
    private int amqpMaxRetries = 0;
    private static String originHost;
    private int graylogPort = 12201;
    private String facility;
    private GelfSender gelfSender;
    private boolean extractStacktrace;
    private boolean addExtendedInformation;
    private boolean includeLocation = true;
    private Map<String, String> fields;

    public void setAdditionalFields(String additionalFields) {
        this.fields = (Map)JSONValue.parse((String)additionalFields.replaceAll("'", "\""));
    }

    public int getGraylogPort() {
        return this.graylogPort;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    public String getGraylogHost() {
        return this.graylogHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    public String getAmqpURI() {
        return this.amqpURI;
    }

    public void setAmqpURI(String amqpURI) {
        this.amqpURI = amqpURI;
    }

    public String getAmqpExchangeName() {
        return this.amqpExchangeName;
    }

    public void setAmqpExchangeName(String amqpExchangeName) {
        this.amqpExchangeName = amqpExchangeName;
    }

    public String getAmqpRoutingKey() {
        return this.amqpRoutingKey;
    }

    public void setAmqpRoutingKey(String amqpRoutingKey) {
        this.amqpRoutingKey = amqpRoutingKey;
    }

    public int getAmqpMaxRetries() {
        return this.amqpMaxRetries;
    }

    public void setAmqpMaxRetries(int amqpMaxRetries) {
        this.amqpMaxRetries = amqpMaxRetries;
    }

    @Override
    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    @Override
    public boolean isExtractStacktrace() {
        return this.extractStacktrace;
    }

    public void setExtractStacktrace(boolean extractStacktrace) {
        this.extractStacktrace = extractStacktrace;
    }

    @Override
    public String getOriginHost() {
        if (originHost == null) {
            originHost = this.getLocalHostName();
        }
        return originHost;
    }

    private String getLocalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.errorHandler.error("Unknown local hostname", (Exception)e, 0);
        }
        return hostName;
    }

    public void setOriginHost(String originHost) {
        GelfAppender.originHost = originHost;
    }

    @Override
    public boolean isAddExtendedInformation() {
        return this.addExtendedInformation;
    }

    public void setAddExtendedInformation(boolean addExtendedInformation) {
        this.addExtendedInformation = addExtendedInformation;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    @Override
    public Map<String, String> getFields() {
        if (this.fields == null) {
            this.fields = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public Object transformExtendedField(String field, Object object) {
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public void activateOptions() {
        if (this.graylogHost == null && this.amqpURI == null) {
            this.errorHandler.error("Graylog2 hostname and amqp uri are empty!", null, 1);
        } else if (this.graylogHost != null && this.amqpURI != null) {
            this.errorHandler.error("Graylog2 hostname and amqp uri are both informed!", null, 1);
        } else {
            try {
                if (this.graylogHost != null && this.graylogHost.startsWith("tcp:")) {
                    String tcpGraylogHost = this.graylogHost.substring(4);
                    this.gelfSender = this.getGelfTCPSender(tcpGraylogHost, this.graylogPort);
                } else if (this.graylogHost != null && this.graylogHost.startsWith("udp:")) {
                    String udpGraylogHost = this.graylogHost.substring(4);
                    this.gelfSender = this.getGelfUDPSender(udpGraylogHost, this.graylogPort);
                } else {
                    this.gelfSender = this.amqpURI != null ? this.getGelfAMQPSender(this.amqpURI, this.amqpExchangeName, this.amqpRoutingKey, this.amqpMaxRetries) : this.getGelfUDPSender(this.graylogHost, this.graylogPort);
                }
            }
            catch (UnknownHostException e) {
                this.errorHandler.error("Unknown Graylog2 hostname:" + this.getGraylogHost(), (Exception)e, 1);
            }
            catch (SocketException e) {
                this.errorHandler.error("Socket exception", (Exception)e, 1);
            }
            catch (IOException e) {
                this.errorHandler.error("IO exception", (Exception)e, 1);
            }
            catch (URISyntaxException e) {
                this.errorHandler.error("AMQP uri exception", (Exception)e, 1);
            }
            catch (NoSuchAlgorithmException e) {
                this.errorHandler.error("AMQP algorithm exception", (Exception)e, 1);
            }
            catch (KeyManagementException e) {
                this.errorHandler.error("AMQP key exception", (Exception)e, 1);
            }
        }
    }

    protected GelfUDPSender getGelfUDPSender(String udpGraylogHost, int graylogPort) throws IOException {
        return new GelfUDPSender(udpGraylogHost, graylogPort);
    }

    protected GelfTCPSender getGelfTCPSender(String tcpGraylogHost, int graylogPort) throws IOException {
        return new GelfTCPSender(tcpGraylogHost, graylogPort);
    }

    protected GelfAMQPSender getGelfAMQPSender(String amqpURI, String amqpExchangeName, String amqpRoutingKey, int amqpMaxRetries) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        return new GelfAMQPSender(amqpURI, amqpExchangeName, amqpRoutingKey, amqpMaxRetries);
    }

    protected void append(LoggingEvent event) {
        GelfMessage gelfMessage = GelfMessageFactory.makeMessage(this.layout, event, this);
        if (this.getGelfSender() == null) {
            this.errorHandler.error("Could not send GELF message. Gelf Sender is not initialised and equals null");
        } else {
            GelfSenderResult gelfSenderResult = this.getGelfSender().sendMessage(gelfMessage);
            if (!GelfSenderResult.OK.equals(gelfSenderResult)) {
                this.errorHandler.error("Error during sending GELF message. Error code: " + gelfSenderResult.getCode() + ".", gelfSenderResult.getException(), 1);
            }
        }
    }

    public GelfSender getGelfSender() {
        return this.gelfSender;
    }

    public void close() {
        GelfSender x = this.getGelfSender();
        if (x != null) {
            x.close();
        }
    }

    public boolean requiresLayout() {
        return true;
    }
}

