/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.ui.DocumentAdapter;
import org.jetbrains.kotlin.com.intellij.ui.Gray;
import org.jetbrains.kotlin.com.intellij.ui.JBColor;
import org.jetbrains.kotlin.com.intellij.ui.paint.LinePainter2D;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.JBHiDPIScaledImage;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.RetinaImage;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.kotlin.com.intellij.util.ui.EdtInvocationManager;
import org.jetbrains.kotlin.com.intellij.util.ui.ImageUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBInsets;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.JBValue;
import org.jetbrains.kotlin.com.intellij.util.ui.accessibility.ScreenReader;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    public static final Key<Boolean> LAF_WITH_THEME_KEY;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final Pattern CLOSE_TAG_PATTERN;
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    @Deprecated
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    public static float DEF_SYSTEM_FONT_SIZE;
    private static final Ref<Boolean> ourRetina;
    private static final AtomicReference<Boolean> jreHiDPI;
    private static volatile boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    @Deprecated
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    @Deprecated
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;
    private static final Color LIST_BACKGROUND;
    private static final JBValue SELECTED_ITEM_ALPHA;

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable JBUI.ScaleContext ctx2) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(ctx2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI.get() != null) {
            return jreHiDPI.get();
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        synchronized (atomicReference) {
            if (jreHiDPI.get() != null) {
                return jreHiDPI.get();
            }
            jreHiDPI.set(false);
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                return false;
            }
            jreHiDPI_earlierVersion = true;
            if (SystemInfo.isJetBrainsJvm) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (ge instanceof SunGraphicsEnvironment) {
                        Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleEnabled", new Class[0]);
                        jreHiDPI.set(m != null && (Boolean)m.invoke((Object)ge, new Object[0]) != false);
                        jreHiDPI_earlierVersion = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (SystemInfo.isMac) {
                jreHiDPI.set(true);
            }
            return jreHiDPI.get();
        }
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    @Deprecated
    public static void drawLine(@NotNull Graphics g, int x1, int y1, int x2, int y2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        LinePainter2D.paint((Graphics2D)g, x1, y1, x2, y2);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    @NotNull
    public static Color getLabelForeground() {
        JBColor jBColor = JBColor.namedColor("Label.foreground", new JBColor(Gray._0, Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        return jBColor;
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type2);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(128);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(129);
        }
        return bufferedImage;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(145);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(146);
        }
        UIUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(155);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(156);
        }
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean hasDstSize = dw >= 0 && dh >= 0;
        Graphics invG = null;
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if ((scale = hidpiImage.getScale()) == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        double _scale = scale;
        Function<Integer, Integer> size = size1 -> (int)Math.round((double)size1.intValue() * _scale);
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = size.fun(dw);
                dh = size.fun(dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = size.fun(srcBounds.x);
                int sy = size.fun(srcBounds.y);
                int sw = srcBounds.width >= 0 ? size.fun(srcBounds.width) : size.fun(userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? size.fun(srcBounds.height) : size.fun(userHeight) - sy;
                if (!hasDstSize) {
                    dw = size.fun(userWidth);
                    dh = size.fun(userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Method dispatchEventMethod = ObjectUtils.notNull(ReflectionUtil.getDeclaredMethod(eventQueue.getClass(), "dispatchEvent", AWTEvent.class));
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.invoke((Object)eventQueue, event);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
            }
            catch (Exception e) {
                LOG.error(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        Thread thread;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            thread = (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (thread == null) {
            UIUtil.$$$reportNull$$$0(166);
        }
        return thread;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(233);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        if (JBUI.SCALE_VERBOSE) {
            LOG.info(String.format("Label font: %s, %d", font.getFontName(), font.getSize()));
        }
        if (SystemInfo.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (JBUI.SCALE_VERBOSE) {
                LOG.info(String.format("gnome.Xft/DPI: %s", value));
            }
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = UIUtil.isJreHiDPIEnabled() ? 1.0f : JBUI.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                if (JBUI.SCALE_VERBOSE) {
                    LOG.info(String.format("DEF_SYSTEM_FONT_SIZE: %.2f", Float.valueOf(DEF_SYSTEM_FONT_SIZE)));
                }
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * UIUtil.getScreenScale();
                font = font.deriveFont(size);
                if (JBUI.SCALE_VERBOSE) {
                    LOG.info(String.format("(Not-JB JRE) reset font size: %.2f", Float.valueOf(size)));
                }
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            if (JBUI.SCALE_VERBOSE) {
                LOG.info(String.format("Windows sys font: %s, %d", winFont.getFontName(), winFont.getSize()));
            }
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
        if (JBUI.SCALE_VERBOSE) {
            LOG.info(String.format("ourSystemFontData: %s, %d", UIUtil.ourSystemFontData.first, UIUtil.ourSystemFontData.second));
        }
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUI.discreteScale((float)dpi / 96.0f);
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(255);
            }
            return jBIterable;
        }
        Container container = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(256);
        }
        return jBIterable;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = LIST_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(323);
        }
        return color;
    }

    static {
        LAF_WITH_THEME_KEY = Key.create("Laf.with.ui.theme");
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$1", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canRedo()) {
                    manager.redo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$2", "actionPerformed"));
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canUndo()) {
                    manager.undo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$3", "actionPerformed"));
            }
        };
        ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
        INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
        CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(Gray.x9B, Gray.x4B));
        SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = Gray.TRANSPARENT;
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            @NotNull
            public Insets getBorderInsets(Component c) {
                JBInsets jBInsets = JBUI.emptyInsets();
                if (jBInsets == null) {
                    4.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, @NotNull Graphics g, int x, int y, int width, int height) {
                if (g == null) {
                    4.$$$reportNull$$$0(1);
                }
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBorderInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "paintBorder";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        DEF_SYSTEM_FONT_SIZE = 12.0f;
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        jreHiDPI = new AtomicReference();
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(c -> {
            JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
            if (c instanceof JComponent) {
                JPopupMenu jpm;
                JComponent jc = (JComponent)c;
                Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                if (orphans != null) {
                    result2 = result2.append(orphans);
                }
                if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                    result2 = result2.append(Collections.singletonList(jpm));
                }
            }
            return result2;
        });
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Document document;
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                if ((document = e.getDocument()) instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = ((UndoManager)listener)::discardAllEdits;
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$11", "textChanged"));
            }
        };
        LIST_BACKGROUND = JBColor.namedColor("List.background", new JBColor(0xFFFFFF, 3948353));
        SELECTED_ITEM_ALPHA = new JBValue.UIInteger("List.selectedItemAlpha", 75);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 41: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 166: 
            case 191: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 221: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 240: 
            case 241: 
            case 242: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 260: 
            case 267: 
            case 269: 
            case 279: 
            case 282: 
            case 284: 
            case 285: 
            case 288: 
            case 295: 
            case 297: 
            case 299: 
            case 302: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 41: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 166: 
            case 191: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 221: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 240: 
            case 241: 
            case 242: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 260: 
            case 267: 
            case 269: 
            case 279: 
            case 282: 
            case 284: 
            case 285: 
            case 288: 
            case 295: 
            case 297: 
            case 299: 
            case 302: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 41: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 166: 
            case 191: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 221: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 240: 
            case 241: 
            case 242: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 260: 
            case 267: 
            case 269: 
            case 279: 
            case 282: 
            case 284: 
            case 285: 
            case 288: 
            case 295: 
            case 297: 
            case 299: 
            case 302: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil";
                break;
            }
            case 6: 
            case 35: 
            case 37: 
            case 39: 
            case 47: 
            case 48: 
            case 49: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 163: 
            case 165: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 13: 
            case 43: 
            case 109: 
            case 195: 
            case 197: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 15: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 21: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: 
            case 45: 
            case 46: 
            case 88: 
            case 89: 
            case 110: 
            case 169: 
            case 171: 
            case 184: 
            case 194: 
            case 239: 
            case 272: 
            case 273: 
            case 275: 
            case 276: 
            case 283: 
            case 301: 
            case 303: 
            case 304: 
            case 316: 
            case 318: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: 
            case 51: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: 
            case 225: 
            case 227: 
            case 229: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 32: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 249: 
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 58: 
            case 60: 
            case 62: 
            case 159: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 70: 
            case 72: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyPrefix";
                break;
            }
            case 83: 
            case 100: 
            case 190: 
            case 204: 
            case 237: 
            case 263: 
            case 315: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 102: 
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 132: 
            case 135: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 161: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintRoutine";
                break;
            }
            case 167: 
            case 170: 
            case 172: 
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 168: 
            case 193: 
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 179: 
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 180: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 219: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 220: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 233: 
            case 234: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 243: 
            case 313: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 244: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 247: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 259: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 262: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 265: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 270: 
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 287: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onWindow";
                break;
            }
            case 289: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 291: 
            case 292: 
            case 306: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 293: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 294: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamProducer";
                break;
            }
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 298: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignSource";
                break;
            }
            case 300: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 311: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 312: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 314: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
            case 319: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 320: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originGraphics";
                break;
            }
            case 321: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextCursor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrayFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextGrayFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellColors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "test_jreHiDPI";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlBody";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelTextBounds";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFont";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFontColor";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForeground";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelDisabledForeground";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextHelpForeground";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTextForeground";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTextBackground";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveTextColor";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextInactiveTextColor";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipBackground";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipActionBackground";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipForeground";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackground";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorForeground";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackgound";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonInformationIcon";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonWarningIcon";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonErrorIcon";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeNodeIcon";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "shade";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getListViewportPadding";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardFontSizes";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "displayPropertiesToCSS";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueueThread";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 196: 
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssFontDeclaration";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedFillColor";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBoundsColor";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundsColor";
                break;
            }
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderActiveColor";
                break;
            }
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBorderColor";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderInactiveColor";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitledBorderFont";
                break;
            }
            case 211: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderInactiveColor";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderActiveColor";
                break;
            }
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderSeparatorColor";
                break;
            }
            case 214: 
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "getHTMLEditorKit";
                break;
            }
            case 217: 
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallback";
                break;
            }
            case 221: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
            case 226: 
            case 228: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 230: {
                objectArray = objectArray2;
                objectArray2[1] = "addPadding";
                break;
            }
            case 232: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 240: 
            case 241: 
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemLookAndFeelClassName";
                break;
            }
            case 254: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 255: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 257: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 260: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
            case 267: 
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratedRowColor";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 284: 
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 288: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugText";
                break;
            }
            case 295: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 297: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 299: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAlignBorder";
                break;
            }
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugImage";
                break;
            }
            case 307: 
            case 308: 
            case 309: 
            case 310: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStyle";
                break;
            }
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 323: 
            case 326: 
            case 327: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 324: 
            case 325: 
            case 328: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 329: {
                objectArray = objectArray2;
                objectArray2[1] = "getListUnfocusedSelectionBackground";
                break;
            }
            case 330: 
            case 332: 
            case 333: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 331: 
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionForeground";
                break;
            }
            case 335: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 336: 
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 337: 
            case 338: 
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeUnfocusedSelectionBackground";
                break;
            }
            case 342: 
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 343: 
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionForeground";
                break;
            }
            case 346: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFont";
                break;
            }
            case 347: 
            case 350: 
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 348: 
            case 349: 
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableUnfocusedSelectionBackground";
                break;
            }
            case 354: 
            case 356: 
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 355: 
            case 358: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleOwner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextCursor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 41: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 166: 
            case 191: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 221: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 240: 
            case 241: 
            case 242: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 260: 
            case 267: 
            case 269: 
            case 279: 
            case 282: 
            case 284: 
            case 285: 
            case 288: 
            case 295: 
            case 297: 
            case 299: 
            case 302: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drawFramingLines";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCellColors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDialogFont";
                break;
            }
            case 15: 
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isWindowClientPropertyTrue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 25: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "drawLinePickedOut";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isReallyTypedEvent";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "drawWave";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "splitText";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getFontSize";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFontColor";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "installPopupMenuColorAndFonts";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "installPopupMenuBorder";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMaxGutterIconWidth";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getTabbedPanePaintContentBorder";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setSliderIsFilled";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "setLineStyleAngled";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "shade";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isControlKeyDown";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingDialogBounds";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "appendColor";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedRectangle";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedLine";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "drawSearchMatch";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "drawRectPickedOut";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "drawBoringDottedLine";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "drawGradientHToolbarBackground";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "drawHeader";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleSpaceDottedLine";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "drawAppleDottedLine";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "applyRenderingHints";
                break;
            }
            case 132: 
            case 135: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "addAwtListener";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "drawVDottedLine";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "drawHDottedLine";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedLine";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "drawStringWithHighlighting";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "drawCenteredString";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "isCloseClick";
                break;
            }
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "isActionClick";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 195: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "disposeProgress";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 219: 
            case 220: 
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 225: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "addPadding";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 234: 
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "setFocusProxy";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstall";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "changeBackGround";
                break;
            }
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardShortcut";
                break;
            }
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "installComboBoxCopyAction";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "fixFormattedField";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedButton";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedButton";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxEditorBounds";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 259: 
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "setFutureRootPane";
                break;
            }
            case 265: 
            case 266: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 270: 
            case 271: {
                objectArray = objectArray;
                objectArray[2] = "mergeComponentsWithAnchor";
                break;
            }
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 275: 
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "getColorAt";
                break;
            }
            case 280: 
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "suppressFocusStealing";
                break;
            }
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "setAutoRequestFocus";
                break;
            }
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "getAllTextsRecursivelyImpl";
                break;
            }
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromResource";
                break;
            }
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromStream";
                break;
            }
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignBorder";
                break;
            }
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "getDebugImage";
                break;
            }
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentOfType";
                break;
            }
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "redirectKeystrokes";
                break;
            }
            case 315: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "typeAheadUntilFocused";
                break;
            }
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "useSafely";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 41: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 166: 
            case 191: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 221: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 240: 
            case 241: 
            case 242: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 260: 
            case 267: 
            case 269: 
            case 279: 
            case 282: 
            case 284: 
            case 285: 
            case 288: 
            case 295: 
            case 297: 
            case 299: 
            case 302: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MouseExitSupportLinkController.$$$reportNull$$$0(0);
            }
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$MouseExitSupportLinkController", "mouseExited"));
        }
    }

    private static class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }

    public static class JBHtmlEditorKit
    extends HTMLEditorKit {
        private final StyleSheet style;
        private final HyperlinkListener myHyperlinkListener;

        @Override
        public Cursor getDefaultCursor() {
            return null;
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
            ss.addStyleSheet(styles);
            HTMLDocument doc = new HTMLDocument(ss);
            doc.setParser(this.getParser());
            doc.setAsynchronousLoadPriority(4);
            doc.setTokenThreshold(100);
            return doc;
        }

        public static StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(UIUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : DEFAULT_HTML_KIT_CSS);
            style.addRule("code { font-size: 100%; }");
            style.addRule("small { font-size: small; }");
            style.addRule("a { text-decoration: none;}");
            style.addRule("ul { margin-left-ltr: 10; margin-right-rtl: 10; }");
            style.addRule("ol { margin-left-ltr: 22; margin-right-rtl: 22; }");
            return style;
        }

        @Override
        public void install(final JEditorPane pane) {
            super.install(pane);
            pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                    pane.removePropertyChangeListener(this);
                }
            });
            pane.addHyperlinkListener(this.myHyperlinkListener);
            List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
            List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
            if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
                HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
                pane.removeMouseListener(oldLinkController);
                pane.removeMouseMotionListener(oldLinkController);
                MouseExitSupportLinkController newLinkController = new MouseExitSupportLinkController();
                pane.addMouseListener(newLinkController);
                pane.addMouseMotionListener(newLinkController);
            }
        }

        @NotNull
        private static List<HTMLEditorKit.LinkController> filterLinkControllerListeners(@NotNull Object[] listeners) {
            if (listeners == null) {
                JBHtmlEditorKit.$$$reportNull$$$0(0);
            }
            List<HTMLEditorKit.LinkController> list2 = ContainerUtil.mapNotNull(listeners, o -> ObjectUtils.tryCast(o, HTMLEditorKit.LinkController.class));
            if (list2 == null) {
                JBHtmlEditorKit.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void deinstall(@NotNull JEditorPane c) {
            if (c == null) {
                JBHtmlEditorKit.$$$reportNull$$$0(2);
            }
            c.removeHyperlinkListener(this.myHyperlinkListener);
            super.deinstall(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listeners";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$JBHtmlEditorKit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/UIUtil$JBHtmlEditorKit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterLinkControllerListeners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "filterLinkControllerListeners";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deinstall";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class DetectRetinaKit {
        private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = ContainerUtil.createWeakMap();

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }
    }
}

