/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text(false);
    public static final NotNullFunction<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final NotNullFunction<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    @NotNull
    public static final Function<String, String> TRIMMER = StringUtil::trim;
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac"};
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        String string2 = StringUtil.replace(text2, oldS, newS, false);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index2;
            int n = index2 = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index2 < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index2);
            newText.append(newS);
            i = index2 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return Strings.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return Strings.toLowerCase(str);
    }

    @Contract(pure=true)
    @NotNull
    public static String getPackageName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return StringUtil.getPackageName(fqName2, '.');
    }

    @Contract(pure=true)
    @NotNull
    public static String getPackageName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(0, lastPointIdx);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(37);
            }
            return string2;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        int count = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset2) {
        LineColumn lineColumn;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text2, offset2)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text2, int offset2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset2; ++curOffset) {
            if (curOffset == text2.length()) {
                return null;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text2.length() - 1 && text2.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset2 - curLineStart);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder2 = buffer;
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        return stringBuilder2;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        String string2 = StringUtilRt.unquoteString(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        return string2;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        String string2 = Introspector.decapitalize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        String string2 = Strings.capitalize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(92);
            }
            return string2;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return Strings.stringHashCode(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        return Strings.stringHashCodeInsensitive(chars);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return Strings.trim(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        String string2 = Strings.trimEnd(s, suffix);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        if (limit > 5 && text2.length() > limit) {
            String string2 = text2.substring(0, limit - 5) + " ...\n";
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(112);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        for (index2 = 0; index2 < string2.length() && string2.charAt(index2) == symbol2; ++index2) {
        }
        String string3 = string2.substring(index2);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        for (index2 = string2.length() - 1; index2 >= 0 && string2.charAt(index2) == symbol2; --index2) {
        }
        String string3 = string2.substring(0, index2 + 1);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return Strings.endsWithChar(s, suffix);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol2, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol2);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value2, String defaultValue2) {
        return StringUtil.isEmpty(value2) ? defaultValue2 : value2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return Strings.isNotEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return Strings.isEmpty(cs);
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        String string2 = Strings.notNullize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue2) {
        if (defaultValue2 == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        String string2 = Strings.notNullize(s, defaultValue2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return Strings.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        String string2 = ExceptionUtil.getThrowableText(aThrowable);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string2 = StringFactory.createShared(buffer);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        return StringUtil.split(s, separator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(160);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index2 = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index2 + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index2 : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        if (items == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        return StringUtil.join(Arrays.asList(items), f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return StringUtil.notNullize(f.fun(items.iterator().next()));
        }
        return StringUtil.join(items, f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        return string2;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        boolean isFirst = true;
        for (T item : items) {
            CharSequence string2 = f.fun(item);
            if (StringUtil.isEmpty(string2)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings2, @NotNull String separator) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (strings2.size() <= 1) {
            return StringUtil.notNullize(ContainerUtil.getFirstItem(strings2));
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings2, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        return string2;
    }

    public static void join(@NotNull Collection<String> strings2, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        boolean isFirst = true;
        for (String string2 : strings2) {
            if (string2 == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (strings2.length == 0) {
            return "";
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string2 : strings2) {
            builder2.append(string2);
        }
        String string3 = builder2.toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull @NonNls String chars) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return Strings.containsAnyChar(value2, chars);
    }

    @Contract(pure=true)
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        return StringUtilRt.startsWith(text2, prefix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        return Strings.endsWith(text2, suffix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        return Strings.indexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return Strings.indexOf(sequence2, infix, start);
    }

    @Contract(pure=true)
    @NotNull
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        String string2 = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (text2.length() <= length) {
            CharSequence charSequence2 = text2;
            if (charSequence2 == null) {
                StringUtil.$$$reportNull$$$0(313);
            }
            return charSequence2;
        }
        if (appendEllipsis) {
            String string2 = text2.subSequence(0, length) + "...";
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(314);
            }
            return string2;
        }
        CharSequence charSequence3 = text2.subSequence(0, length);
        if (charSequence3 == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        return charSequence3;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if (text2.length() <= length) {
            CharSequence charSequence2 = text2;
            if (charSequence2 == null) {
                StringUtil.$$$reportNull$$$0(317);
            }
            return charSequence2;
        }
        if (prependEllipsis) {
            String string2 = "..." + text2.subSequence(text2.length() - length, text2.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(318);
            }
            return string2;
        }
        CharSequence charSequence3 = text2.subSequence(text2.length() - length, text2.length());
        if (charSequence3 == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return charSequence3;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text2, @NotNull List<String> from2, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        if (from2 == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        assert (from2.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i = 0; i < text2.length(); ++i) {
            for (int j = 0; j < from2.size(); ++j) {
                String toReplace = from2.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (len == 0 || !text2.regionMatches(i, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text2.length());
                    result2.append(text2, 0, i);
                }
                result2.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text2.charAt(i));
        }
        String string2 = result2 == null ? text2 : result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset2, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        return StringUtil.countChars(text2, c, offset2, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text2.length(), start);
        end = forward ? Math.min(text2.length(), end) : Math.max(0, end);
        int count = 0;
        int i = forward ? start : start - 1;
        while (forward == i < end) {
            if (text2.charAt(i) == c) {
                ++count;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count;
    }

    @Contract(pure=true)
    @Nullable
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String getQualifiedName(@Nullable @NonNls String packageName, @NotNull @NonNls String className2) {
        if (className2 == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string2 = className2;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(380);
            }
            return string2;
        }
        String string3 = packageName + '.' + className2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        return string3;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts2;
            boolean left = part1.length > idx;
            String[] stringArray = parts2 = left ? part1 : part2;
            while (idx < parts2.length) {
                String p = parts2[idx];
                int cmp = p.matches("\\d+") ? Integer.valueOf(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    @NotNull
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        StringBuilder result2 = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        return string2;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context2 = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context2 = StringUtil.escapeStringCharacters(context2);
            throw new AssertionError((Object)("Wrong line separators: '" + context2 + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol2) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        if (symbol2 == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol2.length();
            assert (prefixLength >= 0);
            String string2 = text2.substring(0, prefixLength) + symbol2 + text2.substring(textLength - suffixLength);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(414);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        String symbol2 = useEllipsisSymbol ? "\u2026" : "...";
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol2);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return Strings.toUpperCase(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortName(@NotNull @NonNls String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        String string2 = StringUtilRt.getShortName(fqName2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return string2;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 57: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 172: 
            case 177: 
            case 180: 
            case 184: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 345: 
            case 347: 
            case 348: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 366: 
            case 368: 
            case 369: 
            case 378: 
            case 380: 
            case 381: 
            case 386: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 406: 
            case 409: 
            case 414: 
            case 415: 
            case 423: 
            case 425: 
            case 428: 
            case 431: 
            case 435: 
            case 437: 
            case 439: 
            case 451: 
            case 453: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 57: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 172: 
            case 177: 
            case 180: 
            case 184: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 345: 
            case 347: 
            case 348: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 366: 
            case 368: 
            case 369: 
            case 378: 
            case 380: 
            case 381: 
            case 386: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 406: 
            case 409: 
            case 414: 
            case 415: 
            case 423: 
            case 425: 
            case 428: 
            case 431: 
            case 435: 
            case 437: 
            case 439: 
            case 451: 
            case 453: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 57: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 172: 
            case 177: 
            case 180: 
            case 184: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 345: 
            case 347: 
            case 348: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 366: 
            case 368: 
            case 369: 
            case 378: 
            case 380: 
            case 381: 
            case 386: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 406: 
            case 409: 
            case 414: 
            case 415: 
            case 423: 
            case 425: 
            case 428: 
            case 431: 
            case 435: 
            case 437: 
            case 439: 
            case 451: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 83: 
            case 84: 
            case 111: 
            case 167: 
            case 170: 
            case 171: 
            case 214: 
            case 252: 
            case 253: 
            case 255: 
            case 257: 
            case 259: 
            case 287: 
            case 299: 
            case 301: 
            case 305: 
            case 307: 
            case 310: 
            case 312: 
            case 316: 
            case 320: 
            case 341: 
            case 342: 
            case 350: 
            case 351: 
            case 353: 
            case 355: 
            case 359: 
            case 360: 
            case 363: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 376: 
            case 382: 
            case 383: 
            case 410: 
            case 411: 
            case 412: 
            case 416: 
            case 420: 
            case 421: 
            case 422: 
            case 424: 
            case 426: 
            case 429: 
            case 457: 
            case 458: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 15: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 80: 
            case 138: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 322: 
            case 323: 
            case 327: 
            case 329: 
            case 330: 
            case 331: 
            case 333: 
            case 336: 
            case 339: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 104: 
            case 107: 
            case 182: 
            case 258: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 131: 
            case 181: 
            case 254: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 35: 
            case 36: 
            case 436: 
            case 438: 
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 46: 
            case 261: 
            case 264: 
            case 266: 
            case 268: 
            case 271: 
            case 403: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 47: 
            case 262: 
            case 265: 
            case 267: 
            case 269: 
            case 272: 
            case 404: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 87: 
            case 89: 
            case 91: 
            case 103: 
            case 106: 
            case 109: 
            case 130: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 162: 
            case 235: 
            case 238: 
            case 241: 
            case 243: 
            case 246: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 285: 
            case 286: 
            case 289: 
            case 291: 
            case 293: 
            case 295: 
            case 297: 
            case 309: 
            case 346: 
            case 384: 
            case 391: 
            case 392: 
            case 401: 
            case 405: 
            case 448: 
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 81: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 231: 
            case 233: 
            case 290: 
            case 292: 
            case 294: 
            case 296: 
            case 298: 
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 101: 
            case 114: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 126: 
            case 248: 
            case 394: 
            case 395: 
            case 397: 
            case 399: 
            case 432: 
            case 445: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 120: 
            case 128: 
            case 337: 
            case 338: 
            case 356: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 134: 
            case 385: 
            case 389: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 173: 
            case 175: 
            case 186: 
            case 190: 
            case 192: 
            case 196: 
            case 200: 
            case 203: 
            case 206: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 174: 
            case 176: 
            case 183: 
            case 202: 
            case 205: 
            case 209: 
            case 211: 
            case 367: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 185: 
            case 189: 
            case 195: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 187: 
            case 188: 
            case 191: 
            case 194: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 201: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 218: 
            case 223: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 229: 
            case 230: 
            case 232: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 236: 
            case 239: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 242: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 277: 
            case 279: 
            case 281: 
            case 283: 
            case 419: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 278: 
            case 280: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 288: 
            case 300: 
            case 302: 
            case 306: 
            case 308: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 326: 
            case 328: 
            case 335: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 343: 
            case 344: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 361: 
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 362: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 379: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 413: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 417: 
            case 418: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 427: 
            case 430: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 434: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 450: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 10: 
            case 366: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 76: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 82: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 105: 
            case 108: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 115: 
            case 117: 
            case 119: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 123: 
            case 125: 
            case 127: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 139: 
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 164: 
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 177: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "joining";
                break;
            }
            case 215: 
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 217: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 220: 
            case 222: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationApproximate";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 251: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 303: 
            case 304: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 311: 
            case 313: 
            case 314: 
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 347: 
            case 348: 
            case 349: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEllipsisSuffix";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 354: 
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 368: 
            case 369: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 380: 
            case 381: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 386: 
            case 387: 
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 393: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 396: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWhiteSpace";
                break;
            }
            case 409: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 414: 
            case 415: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 423: 
            case 425: 
            case 428: 
            case 431: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 435: 
            case 437: 
            case 439: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 453: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 57: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 172: 
            case 177: 
            case 180: 
            case 184: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 345: 
            case 347: 
            case 348: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 366: 
            case 368: 
            case 369: 
            case 378: 
            case 380: 
            case 381: 
            case 386: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 406: 
            case 409: 
            case 414: 
            case 415: 
            case 423: 
            case 425: 
            case 428: 
            case 431: 
            case 435: 
            case 437: 
            case 439: 
            case 451: 
            case 453: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 71: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 81: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 443: 
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 114: 
            case 116: 
            case 118: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 122: 
            case 124: 
            case 126: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 162: 
            case 163: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 181: 
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 221: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "formatDurationPadded";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 241: 
            case 242: 
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 248: 
            case 249: 
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 273: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 274: 
            case 275: 
            case 276: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 301: 
            case 302: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 305: 
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 310: 
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 322: 
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 323: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 327: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 333: 
            case 335: 
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "removeEllipsisSuffix";
                break;
            }
            case 350: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 353: 
            case 355: 
            case 356: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 371: 
            case 372: 
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 385: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 392: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 394: 
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 403: 
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 410: 
            case 412: 
            case 413: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 417: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 422: 
            case 424: 
            case 426: 
            case 427: 
            case 429: 
            case 430: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 434: 
            case 436: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 440: 
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 445: 
            case 446: 
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "hasUpperCaseChar";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "hasLowerCaseChar";
                break;
            }
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 454: 
            case 455: 
            case 456: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
            case 457: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 57: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 172: 
            case 177: 
            case 180: 
            case 184: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 345: 
            case 347: 
            case 348: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 366: 
            case 368: 
            case 369: 
            case 378: 
            case 380: 
            case 381: 
            case 386: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 406: 
            case 409: 
            case 414: 
            case 415: 
            case 423: 
            case 425: 
            case 428: 
            case 431: 
            case 435: 
            case 437: 
            case 439: 
            case 451: 
            case 453: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        @Override
        public void handleText(char @NotNull [] text2, int pos) {
            if (text2 == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text2);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

