/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Exceptions {
    private Exceptions() {
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static NullPointerException nullPointerException(String msg) {
        return new NullPointerException(msg);
    }

    public static NullPointerException nullPointerException(String msg, Object ... args) {
        return new NullPointerException(Exceptions.format(msg, args));
    }

    public static IOException ioException(Throwable cause) {
        return new IOException(cause);
    }

    public static IOException ioException(String msg) {
        return new IOException(msg);
    }

    public static IOException ioException(String msg, Object ... args) {
        return new IOException(Exceptions.format(msg, args));
    }

    public static IOException ioException(Throwable cause, String msg, Object ... args) {
        return new IOException(Exceptions.format(msg, args), cause);
    }

    public static IllegalStateException illegalState(Throwable cause) {
        return new IllegalStateException(cause);
    }

    public static IllegalStateException illegalState(String msg) {
        return new IllegalStateException(msg);
    }

    public static IllegalStateException illegalState(String msg, Object ... args) {
        return new IllegalStateException(Exceptions.format(msg, args));
    }

    public static IllegalStateException illegalState(Throwable cause, String msg, Object ... args) {
        return new IllegalStateException(Exceptions.format(msg, args), cause);
    }

    public static IllegalArgumentException illegalArgument(Throwable cause) {
        return new IllegalArgumentException(cause);
    }

    public static IllegalArgumentException illegalArgument(String msg) {
        return new IllegalArgumentException(msg);
    }

    public static IllegalArgumentException illegalArgument(String msg, Object ... args) {
        return new IllegalArgumentException(Exceptions.format(msg, args));
    }

    public static IllegalArgumentException illegalArgument(Throwable cause, String msg, Object ... args) {
        return new IllegalArgumentException(Exceptions.format(msg, args), cause);
    }

    private static String format(String msg, Object ... args) {
        return args == null || args.length == 0 ? msg : String.format(msg, args);
    }
}

