/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.enc;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jute.base.Exceptions;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.env.Environment;
import org.kuali.common.jute.system.User;

public final class EncryptionPasswordProvider
implements Provider<String> {
    public static final String DEFAULT_ENCRYPTION_PASSWORD = "password";
    private final Environment env;
    private final User user;

    @Inject
    public EncryptionPasswordProvider(Environment env, User user) {
        this.env = Precondition.checkNotNull(env, "env");
        this.user = Precondition.checkNotNull(user, "user");
    }

    public String get() {
        Optional<String> env = this.env.getProperty("enc.password");
        if (env.isPresent()) {
            return (String)env.get();
        }
        Optional<String> home = this.fromUserHome(this.user);
        if (home.isPresent()) {
            return (String)home.get();
        }
        Optional<String> maven = this.fromMavenSettings(this.user, "enc.pwd", "enc.password");
        if (maven.isPresent()) {
            return (String)maven.get();
        }
        System.err.println(String.format("[WARNING] password based encryption is using highly insecure default password -> '%s'", DEFAULT_ENCRYPTION_PASSWORD));
        return DEFAULT_ENCRYPTION_PASSWORD;
    }

    private Optional<String> fromUserHome(User user) {
        File file = new File(user.getHome(), "/.enc/password");
        if (!file.isFile()) {
            return Optional.absent();
        }
        try {
            return Optionals.fromTrimToNull(Files.asCharSource((File)file, (Charset)Charsets.UTF_8).readFirstLine());
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    private Optional<String> fromMavenSettings(User user, String ... tokens) {
        File file = new File(user.getHome(), "/.m2/settings.xml");
        if (!file.isFile()) {
            return Optional.absent();
        }
        try {
            String content = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            for (String token : tokens) {
                Optional<String> optional = Optionals.fromTrimToNull(StringUtils.substringBetween((String)content, (String)("<" + token + ">"), (String)("</" + token + ">")));
                if (!optional.isPresent()) continue;
                return optional;
            }
            return Optional.absent();
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    public Environment getEnv() {
        return this.env;
    }

    public User getUser() {
        return this.user;
    }
}

