/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.enc.cipher;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import org.kuali.common.jute.base.Exceptions;

public final class Ciphers {
    private Ciphers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cipheredCopy(ByteSource source, ByteSink sink, Cipher cipher) throws IOException {
        try (Closer closer = Closer.create();){
            OutputStream out = (OutputStream)closer.register((Closeable)sink.openBufferedStream());
            Ciphers.cipheredCopy(source, out, cipher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cipheredCopy(ByteSource source, OutputStream out, Cipher cipher) throws IOException {
        try (Closer closer = Closer.create();){
            InputStream in = (InputStream)closer.register((Closeable)source.openBufferedStream());
            Ciphers.cipheredCopy(in, out, cipher);
        }
    }

    public static void cipheredCopy(InputStream in, OutputStream out, Cipher cipher) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int length = in.read(buffer);
            while (length != -1) {
                out.write(cipher.update(buffer, 0, length));
                length = in.read(buffer);
            }
            out.write(cipher.doFinal());
        }
        catch (Exception e) {
            throw Exceptions.ioException(e);
        }
    }
}

