/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.enc.openssl;

import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import org.kuali.common.jute.base.Exceptions;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.enc.Encryptor;
import org.kuali.common.jute.enc.cipher.CipherMode;
import org.kuali.common.jute.enc.cipher.Ciphers;
import org.kuali.common.jute.enc.openssl.OpenSSLContext;
import org.kuali.common.jute.enc.openssl.OpenSSLSaltContext;

public final class OpenSSLEncryptor
implements Encryptor {
    private final OpenSSLContext context;

    @Inject
    public OpenSSLEncryptor(OpenSSLContext context) {
        this.context = Precondition.checkNotNull(context, "context");
    }

    @Override
    public String encrypt(String plaintext) {
        ByteSource prefix = ByteSource.wrap((byte[])this.context.getSalt().getPrefix().getBytes(this.context.getCharset()));
        ByteSource salt = OpenSSLEncryptor.buildSalt(this.context.getSalt());
        ByteSource secret = ByteSource.wrap((byte[])this.context.getPassword().getBytes(this.context.getCharset()));
        Cipher cipher = OpenSSLEncryptor.buildCipher(this.context, CipherMode.ENCRYPT, secret, salt);
        try {
            ByteSource source = ByteSource.wrap((byte[])plaintext.getBytes(this.context.getCharset()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Ciphers.cipheredCopy(source, (OutputStream)out, cipher);
            ByteSource encrypted = ByteSource.wrap((byte[])out.toByteArray());
            ByteSource combined = ByteSource.concat((ByteSource[])new ByteSource[]{prefix, salt, encrypted});
            return this.context.getEncoder().encode(combined.read());
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        byte[] bytes = this.context.getEncoder().decode((CharSequence)encrypted);
        int prefixLength = this.context.getSalt().getPrefix().length();
        int saltBytes = this.context.getSalt().getBytes();
        int encryptedOffset = prefixLength + saltBytes;
        int encryptedLength = bytes.length - encryptedOffset;
        ByteSource all = ByteSource.wrap((byte[])bytes);
        ByteSource salt = all.slice((long)prefixLength, (long)saltBytes);
        ByteSource source = all.slice((long)encryptedLength, (long)encryptedOffset);
        ByteSource secret = ByteSource.wrap((byte[])this.context.getPassword().getBytes(this.context.getCharset()));
        Cipher cipher = OpenSSLEncryptor.buildCipher(this.context, CipherMode.DECRYPT, secret, salt);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Ciphers.cipheredCopy(source, (OutputStream)out, cipher);
            byte[] decrypted = out.toByteArray();
            return new String(decrypted, this.context.getCharset());
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    public OpenSSLContext getContext() {
        return this.context;
    }

    private static ByteSource buildSalt(OpenSSLSaltContext context) {
        byte[] bytes = new byte[context.getBytes()];
        Random random = context.isSecure() ? new SecureRandom() : new Random();
        random.nextBytes(bytes);
        return ByteSource.wrap((byte[])bytes);
    }

    private static Cipher buildCipher(OpenSSLContext context, CipherMode mode, ByteSource data, ByteSource salt) {
        try {
            Cipher cipher = Cipher.getInstance(context.getTransformation());
            int initVectorLength = cipher.getBlockSize();
            MessageDigest md = MessageDigest.getInstance(context.getDigest());
            int keyLength = context.getKeyBits() / 8;
            int keyIndex = 0;
            int initVectorIndex = 0;
            byte[] key = new byte[keyLength];
            byte[] initVector = new byte[initVectorLength];
            byte[] digestBuffer = null;
            int i = 0;
            int addDigest = 0;
            do {
                md.reset();
                if (addDigest++ > 0) {
                    md.update(digestBuffer);
                }
                md.update(data.read());
                if (salt != null) {
                    md.update(salt.read());
                }
                digestBuffer = md.digest();
                for (i = 1; i < context.getIterations(); ++i) {
                    md.reset();
                    md.update(digestBuffer);
                    digestBuffer = md.digest();
                }
                if (keyLength > 0) {
                    for (i = 0; keyLength != 0 && i != digestBuffer.length; --keyLength, ++i) {
                        key[keyIndex++] = digestBuffer[i];
                    }
                }
                if (initVectorLength <= 0 || i == digestBuffer.length) continue;
                while (initVectorLength != 0 && i != digestBuffer.length) {
                    initVector[initVectorIndex++] = digestBuffer[i];
                    --initVectorLength;
                    ++i;
                }
            } while (keyLength != 0 || initVectorLength != 0);
            for (i = 0; i < digestBuffer.length; ++i) {
                digestBuffer[i] = 0;
            }
            SecretKeySpec initKey = new SecretKeySpec(key, context.getEncryption());
            IvParameterSpec initParams = new IvParameterSpec(initVector);
            cipher.init(mode.getValue(), (Key)initKey, initParams);
            return cipher;
        }
        catch (Exception e) {
            throw Exceptions.illegalState(e);
        }
    }
}

