/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.env;

import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;

public final class EnvironmentVariables {
    private EnvironmentVariables() {
    }

    public static ImmutableList<Function<String, String>> alternateKeyFunctions() {
        return ImmutableList.copyOf((Object[])AlternateKeyFunctions.values());
    }

    private static enum AlternateKeyFunctions implements Function<String, String>
    {
        CAMEL_CASE_UNDERSCORE_UPPER{

            public String apply(String input) {
                return (String)Functions.compose((Function)UNDERSCORE, (Function)CAMEL_CASE_UPPER).apply((Object)input);
            }
        }
        ,
        UNDERSCORE{

            public String apply(String input) {
                return input.replace('.', '_');
            }
        }
        ,
        UPPERCASE{

            public String apply(String input) {
                return input.toUpperCase();
            }
        }
        ,
        UNDERSCORE_UPPERCASE{

            public String apply(String input) {
                return (String)Functions.compose((Function)UPPERCASE, (Function)UNDERSCORE).apply((Object)input);
            }
        }
        ,
        CAMEL_CASE_LOWER{

            public String apply(String input) {
                char[] chars = input.toCharArray();
                StringBuilder sb = new StringBuilder();
                char prevChar = '\u0000';
                for (char c : chars) {
                    if (Ascii.isUpperCase((char)c) && Ascii.isLowerCase((char)prevChar)) {
                        sb.append('.');
                        sb.append(Character.toLowerCase(c));
                    } else {
                        sb.append(c);
                    }
                    prevChar = c;
                }
                return sb.toString();
            }
        }
        ,
        CAMEL_CASE_UPPER{

            public String apply(String input) {
                return (String)Functions.compose((Function)UPPERCASE, (Function)CAMEL_CASE_LOWER).apply((Object)input);
            }
        }
        ,
        CAMEL_CASE_UNDERSCORE_LOWER{

            public String apply(String input) {
                return (String)Functions.compose((Function)UNDERSCORE, (Function)CAMEL_CASE_LOWER).apply((Object)input);
            }
        };

    }
}

