/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.env;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.env.AlternateKeyFunctions;
import org.kuali.common.jute.env.Environment;
import org.kuali.common.jute.system.VirtualSystem;

public final class StandardEnvironment
implements Environment {
    private final VirtualSystem system;
    private final ImmutableList<Function<String, String>> alternateKeyFunctions;

    @Inject
    public StandardEnvironment(VirtualSystem system, @AlternateKeyFunctions List<Function<String, String>> alternateKeyFunctions) {
        this.system = Precondition.checkNotNull(system, "system");
        this.alternateKeyFunctions = ImmutableList.copyOf(alternateKeyFunctions);
    }

    public VirtualSystem getSystem() {
        return this.system;
    }

    @Override
    public Optional<String> getProperty(String key) {
        Precondition.checkNotBlank(key, "key");
        Optional sys = Optional.fromNullable((Object)this.system.getProperties().getProperty(key));
        if (sys.isPresent()) {
            return sys;
        }
        Optional env = Optional.fromNullable((Object)this.system.getEnvironment().getProperty(key));
        if (env.isPresent()) {
            return env;
        }
        for (Function alternateKeyFunction : this.alternateKeyFunctions) {
            String alternateKey = (String)alternateKeyFunction.apply((Object)key);
            env = Optional.fromNullable((Object)this.system.getEnvironment().getProperty(alternateKey));
            if (!env.isPresent()) continue;
            return env;
        }
        return Optional.absent();
    }

    @Override
    public boolean containsProperty(String key) {
        Precondition.checkNotBlank(key, "key");
        return this.getProperty(key).isPresent();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        Precondition.checkNotBlank(key, "key");
        Optional<String> value = this.getProperty(key);
        if (value.isPresent()) {
            return (String)value.get();
        }
        return defaultValue;
    }

    @Override
    public String getRequiredProperty(String key) {
        Optional<String> value = this.getProperty(key);
        Preconditions.checkState((boolean)value.isPresent(), (String)"'%s' is required", (Object[])new Object[]{key});
        return (String)value.get();
    }
}

