/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.json.jackson;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.io.BaseEncoding;
import com.google.inject.Provider;
import javax.inject.Inject;
import org.kuali.common.jute.env.EmptyEnvironment;
import org.kuali.common.jute.env.Environment;
import org.kuali.common.jute.json.jackson.ByteSourceModule;
import org.kuali.common.jute.json.jackson.JsonBaseEncoding;
import org.kuali.common.jute.reflect.Reflection;

public final class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final Environment env;
    private final BaseEncoding encoder;

    public ObjectMapper get() {
        boolean guava = Boolean.parseBoolean(this.env.getProperty("jackson.module.guava", "true"));
        boolean byteSource = Boolean.parseBoolean(this.env.getProperty("jackson.module.byteSource", "true"));
        boolean prettyPrint = Boolean.parseBoolean(this.env.getProperty("jackson.prettyPrint", "true"));
        boolean sortProperties = Boolean.parseBoolean(this.env.getProperty("jackson.sort.properties", "true"));
        boolean sortMaps = Boolean.parseBoolean(this.env.getProperty("jackson.sort.maps", "true"));
        ObjectMapper mapper = new ObjectMapper();
        if (guava) {
            mapper.registerModule((Module)new GuavaModule());
        }
        if (byteSource) {
            mapper.registerModule((Module)new ByteSourceModule(this.encoder));
        }
        if (sortProperties) {
            mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        }
        if (sortMaps) {
            mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        }
        if (prettyPrint) {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        return mapper;
    }

    public static ObjectMapperProvider build() {
        return ObjectMapperProvider.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ObjectMapperProvider(Builder builder) {
        this.env = builder.env;
        this.encoder = builder.encoder;
    }

    public Environment getEnv() {
        return this.env;
    }

    public BaseEncoding getEncoder() {
        return this.encoder;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<ObjectMapperProvider>,
    Provider<ObjectMapperProvider> {
        private Environment env = EmptyEnvironment.INSTANCE;
        private BaseEncoding encoder = BaseEncoding.base64();

        @Inject
        public Builder withEnv(Environment env) {
            this.env = env;
            return this;
        }

        @Inject
        public Builder withEncoder(@JsonBaseEncoding BaseEncoding encoder) {
            this.encoder = encoder;
            return this;
        }

        public ObjectMapperProvider get() {
            return this.build();
        }

        public ObjectMapperProvider build() {
            return Reflection.checkNoNulls(new ObjectMapperProvider(this));
        }

        public Environment getEnv() {
            return this.env;
        }

        public void setEnv(Environment env) {
            this.env = env;
        }

        public BaseEncoding getEncoder() {
            return this.encoder;
        }

        public void setEncoder(BaseEncoding encoder) {
            this.encoder = encoder;
        }
    }
}

