/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class GarbageCollectionEvent {
    private final String name;
    private final Optional<Long> count;
    private final Optional<Long> millis;

    private GarbageCollectionEvent(Builder builder) {
        this.name = builder.name;
        this.count = builder.count;
        this.millis = builder.millis;
    }

    public static List<GarbageCollectionEvent> buildAll() {
        ArrayList events = Lists.newArrayList();
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            GarbageCollectionEvent event = GarbageCollectionEvent.copyOf(bean);
            events.add(event);
        }
        return ImmutableList.copyOf((Collection)events);
    }

    public static GarbageCollectionEvent copyOf(GarbageCollectorMXBean bean) {
        Builder builder = GarbageCollectionEvent.builder();
        builder.withName(bean.getName());
        builder.withCount(Optionals.fromNegativeToAbsent(bean.getCollectionCount()));
        builder.withMillis(Optionals.fromNegativeToAbsent(bean.getCollectionTime()));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Optional<Long> getCount() {
        return this.count;
    }

    public Optional<Long> getMillis() {
        return this.millis;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<GarbageCollectionEvent> {
        private String name;
        private Optional<Long> count;
        private Optional<Long> millis;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCount(Optional<Long> count) {
            this.count = count;
            return this;
        }

        public Builder withMillis(Optional<Long> millis) {
            this.millis = millis;
            return this;
        }

        public GarbageCollectionEvent build() {
            return Builder.validate(new GarbageCollectionEvent(this));
        }

        public static GarbageCollectionEvent validate(GarbageCollectionEvent instance) {
            Reflection.checkNoNulls(instance);
            Precondition.checkNotBlank(instance.name, "name");
            Precondition.checkMin((Optional<Long>)instance.count, 0L, "count");
            Precondition.checkMin((Optional<Long>)instance.millis, 0L, "millis");
            return instance;
        }
    }
}

