/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.reflect.Reflection;
import org.kuali.common.jute.runtime.ClassLoading;
import org.kuali.common.jute.runtime.GarbageCollectionEvent;
import org.kuali.common.jute.runtime.Memory;
import org.kuali.common.jute.runtime.ProcessIdProvider;
import org.kuali.common.jute.runtime.Threads;
import org.kuali.common.jute.runtime.Uptime;
import org.kuali.common.jute.runtime.annotation.GarbageCollectionEvents;
import org.kuali.common.jute.runtime.annotation.ProcessId;
import org.kuali.common.jute.runtime.annotation.Processors;
import org.kuali.common.jute.runtime.annotation.SystemLoadAverage;

@JsonDeserialize(builder=Builder.class)
public final class VirtualRuntime {
    private final int processors;
    private final Memory memory;
    private final Uptime uptime;
    private final Optional<Integer> pid;
    private final ClassLoading classLoading;
    private final Threads threads;
    private final ImmutableList<GarbageCollectionEvent> garbageCollectionEvents;
    private final Optional<Double> systemLoadAverage;

    private VirtualRuntime(Builder builder) {
        this.processors = builder.processors;
        this.memory = builder.memory;
        this.uptime = builder.uptime;
        this.pid = builder.pid;
        this.systemLoadAverage = builder.systemLoadAverage;
        this.classLoading = builder.classLoading;
        this.threads = builder.threads;
        this.garbageCollectionEvents = ImmutableList.copyOf((Collection)builder.garbageCollectionEvents);
    }

    public static VirtualRuntime build() {
        Builder builder = VirtualRuntime.builder();
        builder.withProcessors(Runtime.getRuntime().availableProcessors());
        builder.withMemory(Memory.build());
        builder.withUptime(Uptime.build());
        builder.withPid(ProcessIdProvider.INSTANCE.get());
        builder.withClassLoading(ClassLoading.build());
        builder.withThreads(Threads.build());
        builder.withGarbageCollectionEvents(GarbageCollectionEvent.buildAll());
        builder.withSystemLoadAverage(Optionals.fromNegativeToAbsent(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage()));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getProcessors() {
        return this.processors;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Uptime getUptime() {
        return this.uptime;
    }

    public Optional<Integer> getPid() {
        return this.pid;
    }

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public List<GarbageCollectionEvent> getGarbageCollectionEvents() {
        return this.garbageCollectionEvents;
    }

    public Optional<Double> getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<VirtualRuntime>,
    Provider<VirtualRuntime> {
        private int processors;
        private Memory memory;
        private Uptime uptime;
        private Optional<Integer> pid = Optional.absent();
        private ClassLoading classLoading;
        private Threads threads;
        private List<GarbageCollectionEvent> garbageCollectionEvents = Lists.newArrayList();
        private Optional<Double> systemLoadAverage = Optional.absent();

        @Inject
        public Builder withSystemLoadAverage(@SystemLoadAverage Optional<Double> systemLoadAverage) {
            this.systemLoadAverage = systemLoadAverage;
            return this;
        }

        @Inject
        public Builder withGarbageCollectionEvents(@GarbageCollectionEvents List<GarbageCollectionEvent> garbageCollectionEvents) {
            this.garbageCollectionEvents = garbageCollectionEvents;
            return this;
        }

        @Inject
        public Builder withThreads(Threads threads) {
            this.threads = threads;
            return this;
        }

        @Inject
        public Builder withClassLoading(ClassLoading classLoading) {
            this.classLoading = classLoading;
            return this;
        }

        @Inject
        public Builder withPid(@ProcessId Optional<Integer> pid) {
            this.pid = pid;
            return this;
        }

        @Inject
        public Builder withUptime(Uptime uptime) {
            this.uptime = uptime;
            return this;
        }

        @Inject
        public Builder withProcessors(@Processors int processors) {
            this.processors = processors;
            return this;
        }

        @Inject
        public Builder withMemory(Memory memory) {
            this.memory = memory;
            return this;
        }

        public VirtualRuntime get() {
            return this.build();
        }

        public VirtualRuntime build() {
            return Reflection.checkNoNulls(new VirtualRuntime(this));
        }
    }
}

