/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class OperatingSystem {
    private final String name;
    private final String arch;
    private final String version;

    private OperatingSystem(Builder builder) {
        this.name = builder.name;
        this.arch = builder.arch;
        this.version = builder.version;
    }

    public static OperatingSystem build() {
        Builder builder = OperatingSystem.builder();
        builder.withName(StandardSystemProperty.OS_NAME.value());
        builder.withArch(StandardSystemProperty.OS_ARCH.value());
        builder.withVersion(StandardSystemProperty.OS_VERSION.value());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<OperatingSystem> {
        private String name;
        private String arch;
        private String version;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArch(String arch) {
            this.arch = arch;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public OperatingSystem build() {
            return Reflection.checkNoNulls(new OperatingSystem(this));
        }
    }
}

