/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class Specification {
    private final String name;
    private final String version;
    private final String vendor;

    private Specification(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.vendor = builder.vendor;
    }

    public static Specification buildRuntimeEnvironmentSpecification() {
        Builder builder = Specification.builder();
        builder.withVendor(StandardSystemProperty.JAVA_SPECIFICATION_VENDOR.value());
        builder.withVersion(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value());
        builder.withName(StandardSystemProperty.JAVA_SPECIFICATION_NAME.value());
        return builder.build();
    }

    public static Specification buildVirtualMachineSpecification() {
        Builder builder = Specification.builder();
        builder.withVendor(StandardSystemProperty.JAVA_VM_SPECIFICATION_VENDOR.value());
        builder.withVersion(StandardSystemProperty.JAVA_VM_SPECIFICATION_VERSION.value());
        builder.withName(StandardSystemProperty.JAVA_VM_SPECIFICATION_NAME.value());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<Specification> {
        private String name;
        private String version;
        private String vendor;

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Specification build() {
            return Reflection.checkNoNulls(new Specification(this));
        }
    }
}

