/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.jute.base.Precondition;

public final class SystemFiles {
    private static final Splitter SPLITTER = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings().trimResults();

    public static List<File> fromSystemProperty(StandardSystemProperty property) {
        String value = Precondition.checkNotBlank(property.value(), property.key());
        ArrayList files = Lists.newArrayList();
        Iterable paths = SPLITTER.split((CharSequence)value);
        for (String path : paths) {
            File file = new File(path);
            files.add(file);
        }
        return ImmutableList.copyOf((Collection)files);
    }
}

