/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.AbstractModule;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.kuali.common.jute.collect.ImmutableProperties;
import org.kuali.common.jute.system.Java;
import org.kuali.common.jute.system.OperatingSystem;
import org.kuali.common.jute.system.User;
import org.kuali.common.jute.system.VirtualSystem;
import org.kuali.common.jute.system.annotation.EnvironmentVariables;
import org.kuali.common.jute.system.annotation.FileSeparator;
import org.kuali.common.jute.system.annotation.LineSeparator;
import org.kuali.common.jute.system.annotation.PathSeparator;
import org.kuali.common.jute.system.annotation.SystemCharset;
import org.kuali.common.jute.system.annotation.SystemLocale;
import org.kuali.common.jute.system.annotation.SystemProperties;
import org.kuali.common.jute.system.annotation.SystemTimezone;

public class SystemModule
extends AbstractModule {
    protected void configure() {
        this.bind(User.class).toInstance((Object)User.build());
        this.bind(OperatingSystem.class).toInstance((Object)OperatingSystem.build());
        this.bind(Java.class).toInstance((Object)Java.build());
        this.bindConstant().annotatedWith(LineSeparator.class).to(StandardSystemProperty.LINE_SEPARATOR.value());
        this.bindConstant().annotatedWith(PathSeparator.class).to(StandardSystemProperty.PATH_SEPARATOR.value());
        this.bindConstant().annotatedWith(FileSeparator.class).to(StandardSystemProperty.FILE_SEPARATOR.value());
        this.bindConstant().annotatedWith(SystemTimezone.class).to(TimeZone.getDefault().getID());
        this.bind(Charset.class).annotatedWith(SystemCharset.class).toInstance((Object)Charset.defaultCharset());
        this.bind(Locale.class).annotatedWith(SystemLocale.class).toInstance((Object)Locale.getDefault());
        this.bind(Properties.class).annotatedWith(SystemProperties.class).toInstance((Object)ImmutableProperties.copyOf(System.getProperties()));
        this.bind(Properties.class).annotatedWith(EnvironmentVariables.class).toInstance((Object)ImmutableProperties.copyOf(System.getenv()));
        this.bind(VirtualSystem.class).toProvider(VirtualSystem.Builder.class).asEagerSingleton();
    }
}

