/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Provider;
import org.kuali.common.jute.collect.ImmutableProperties;
import org.kuali.common.jute.reflect.Reflection;
import org.kuali.common.jute.system.Java;
import org.kuali.common.jute.system.OperatingSystem;
import org.kuali.common.jute.system.User;
import org.kuali.common.jute.system.annotation.EnvironmentVariables;
import org.kuali.common.jute.system.annotation.FileSeparator;
import org.kuali.common.jute.system.annotation.LineSeparator;
import org.kuali.common.jute.system.annotation.PathSeparator;
import org.kuali.common.jute.system.annotation.SystemCharset;
import org.kuali.common.jute.system.annotation.SystemLocale;
import org.kuali.common.jute.system.annotation.SystemProperties;
import org.kuali.common.jute.system.annotation.SystemTimezone;

@JsonDeserialize(builder=Builder.class)
public final class VirtualSystem {
    private final User user;
    private final OperatingSystem os;
    private final Java java;
    private final String lineSeparator;
    private final String pathSeparator;
    private final String fileSeparator;
    private final ImmutableProperties properties;
    private final ImmutableProperties environment;
    private final Locale locale;
    private final Charset charset;
    private final String timezone;

    public static VirtualSystem build() {
        Builder builder = VirtualSystem.builder();
        builder.withUser(User.build());
        builder.withOs(OperatingSystem.build());
        builder.withJava(Java.build());
        builder.withFileSeparator(StandardSystemProperty.FILE_SEPARATOR.value());
        builder.withLineSeparator(StandardSystemProperty.LINE_SEPARATOR.value());
        builder.withPathSeparator(StandardSystemProperty.PATH_SEPARATOR.value());
        builder.withProperties(ImmutableProperties.copyOf(System.getProperties()));
        builder.withEnvironment(ImmutableProperties.copyOf(System.getenv()));
        builder.withLocale(Locale.getDefault());
        builder.withCharset(Charset.defaultCharset());
        builder.withTimezone(TimeZone.getDefault().getID());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private VirtualSystem(Builder builder) {
        this.user = builder.user;
        this.os = builder.os;
        this.java = builder.java;
        this.lineSeparator = builder.lineSeparator;
        this.pathSeparator = builder.pathSeparator;
        this.fileSeparator = builder.fileSeparator;
        this.properties = ImmutableProperties.copyOf(builder.properties);
        this.environment = ImmutableProperties.copyOf(builder.environment);
        this.locale = builder.locale;
        this.charset = builder.charset;
        this.timezone = builder.timezone;
    }

    public User getUser() {
        return this.user;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public Java getJava() {
        return this.java;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public ImmutableProperties getEnvironment() {
        return this.environment;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<VirtualSystem>,
    Provider<VirtualSystem> {
        private User user;
        private OperatingSystem os;
        private Java java;
        private String lineSeparator;
        private String pathSeparator;
        private String fileSeparator;
        private Properties properties;
        private Properties environment;
        private Locale locale;
        private Charset charset;
        private String timezone;

        @Inject
        public Builder withCharset(@SystemCharset Charset charset) {
            this.charset = charset;
            return this;
        }

        @Inject
        public Builder withTimezone(@SystemTimezone String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Inject
        public Builder withLocale(@SystemLocale Locale locale) {
            this.locale = locale;
            return this;
        }

        @Inject
        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        @Inject
        public Builder withOs(OperatingSystem os) {
            this.os = os;
            return this;
        }

        @Inject
        public Builder withJava(Java java) {
            this.java = java;
            return this;
        }

        @Inject
        public Builder withLineSeparator(@LineSeparator String lineSeparator) {
            this.lineSeparator = lineSeparator;
            return this;
        }

        @Inject
        public Builder withPathSeparator(@PathSeparator String pathSeparator) {
            this.pathSeparator = pathSeparator;
            return this;
        }

        @Inject
        public Builder withFileSeparator(@FileSeparator String fileSeparator) {
            this.fileSeparator = fileSeparator;
            return this;
        }

        @Inject
        public Builder withProperties(@SystemProperties Properties properties) {
            this.properties = properties;
            return this;
        }

        @Inject
        public Builder withEnvironment(@EnvironmentVariables Properties environment) {
            this.environment = environment;
            return this;
        }

        public VirtualSystem get() {
            return this.build();
        }

        public VirtualSystem build() {
            return Reflection.checkNoNulls(new VirtualSystem(this));
        }
    }
}

