/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.spring;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.kuali.common.maven.spring.MavenAwareUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.MavenUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AugmentMavenPropertiesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(AugmentMavenPropertiesExecutable.class);
    MavenProject mavenProject;
    boolean skip;

    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution");
            return;
        }
        Assert.notNull((Object)this.mavenProject, (String)"mavenProject is null");
        Properties mavenProperties = this.mavenProject.getProperties();
        int originalSize = mavenProperties.size();
        Properties internal = MavenAwareUtils.getInternalProperties(this.mavenProject);
        mavenProperties.putAll((Map<?, ?>)internal);
        MavenUtils.augmentProjectProperties((Properties)mavenProperties);
        logger.debug("Added {} properties", (Object)FormatUtils.getCount((long)(mavenProperties.size() - originalSize)));
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

