/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.RepositoryUtils;

public class MavenAwareUtils {
    public static Properties getInternalProperties(MavenProject project) {
        Properties properties = new Properties();
        MavenAwareUtils.nullSafeSet(properties, "project.id", project.getId());
        MavenAwareUtils.nullSafeSet(properties, "project.groupId", project.getGroupId());
        MavenAwareUtils.nullSafeSet(properties, "project.artifactId", project.getArtifactId());
        MavenAwareUtils.nullSafeSet(properties, "project.version", project.getVersion());
        MavenAwareUtils.nullSafeSet(properties, "project.packaging", project.getPackaging());
        MavenAwareUtils.nullSafeSet(properties, "project.name", project.getName());
        MavenAwareUtils.nullSafeSet(properties, "project.description", project.getDescription());
        MavenAwareUtils.nullSafeSet(properties, "project.inceptionYear", project.getInceptionYear());
        MavenAwareUtils.nullSafeSet(properties, "project.basedir", LocationUtils.getCanonicalPath((File)project.getBasedir()));
        if (project.getCiManagement() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.ciManagement.system", project.getCiManagement().getSystem());
            MavenAwareUtils.nullSafeSet(properties, "project.ciManagement.url", project.getCiManagement().getUrl());
        }
        if (project.getIssueManagement() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.issueManagement.system", project.getIssueManagement().getSystem());
            MavenAwareUtils.nullSafeSet(properties, "project.issueManagement.url", project.getIssueManagement().getUrl());
        }
        if (project.getBuild() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.build.directory", project.getBuild().getDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.outputDirectory", project.getBuild().getOutputDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.testOutputDirectory", project.getBuild().getTestOutputDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.sourceDirectory", project.getBuild().getSourceDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.scriptSourceDirectory", project.getBuild().getScriptSourceDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.testSourceDirectory", project.getBuild().getTestSourceDirectory());
        }
        if (project.getScm() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.scm.connection", project.getScm().getConnection());
            MavenAwareUtils.nullSafeSet(properties, "project.scm.developerConnection", project.getScm().getDeveloperConnection());
            MavenAwareUtils.nullSafeSet(properties, "project.scm.url", project.getScm().getDeveloperConnection());
        }
        MavenAwareUtils.nullSafeSet(properties, "project.pom.location", MavenAwareUtils.getPomLocation(project));
        if (project.getDependencies() != null) {
            List<org.kuali.common.util.Dependency> pojos = MavenAwareUtils.convertToSimplePojos(project.getDependencies());
            if (pojos.size() == 0) {
                MavenAwareUtils.nullSafeSet(properties, "project.dependencies", "NONE");
            } else {
                MavenAwareUtils.nullSafeSet(properties, "project.dependencies", MavenAwareUtils.getDependenciesCSV(pojos));
            }
        } else {
            MavenAwareUtils.nullSafeSet(properties, "project.dependencies", "NONE");
        }
        return properties;
    }

    public static void nullSafeSet(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public static String getPomLocation(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append("META-INF");
        sb.append("/");
        sb.append("maven");
        sb.append("/");
        sb.append(project.getGroupId());
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("/");
        sb.append("pom.xml");
        return sb.toString();
    }

    public static List<org.kuali.common.util.Dependency> convertToSimplePojos(List<Dependency> dependencies) {
        ArrayList<org.kuali.common.util.Dependency> pojos = new ArrayList<org.kuali.common.util.Dependency>();
        for (Dependency d : dependencies) {
            org.kuali.common.util.Dependency pojo = new org.kuali.common.util.Dependency();
            pojo.setGroupId(d.getGroupId());
            pojo.setArtifactId(d.getArtifactId());
            pojo.setVersion(d.getVersion());
            pojo.setClassifier(d.getClassifier());
            pojo.setType(d.getType());
            pojo.setScope(d.getScope());
            pojos.add(pojo);
        }
        return pojos;
    }

    public static String getDependenciesCSV(List<org.kuali.common.util.Dependency> dependencies) {
        if (CollectionUtils.isEmpty(dependencies)) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dependencies.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            org.kuali.common.util.Dependency dependency = dependencies.get(i);
            sb.append(RepositoryUtils.toString((org.kuali.common.util.Dependency)dependency));
        }
        return sb.toString();
    }
}

