/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.spring;

import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.SetSourceDbSchemaNameExecutable;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SetSourceDbSchemaNameConfig {
    @Autowired
    Environment env;
    @Autowired
    @Qualifier(value="mavenProject")
    MavenProject mavenProject;

    @Bean(initMethod="execute")
    public Executable setSourceDbSchemaNameExecutable() {
        boolean skip = SpringUtils.getBoolean((Environment)this.env, (String)"jdbc.source.db.setSchemaName.skip", (boolean)false);
        String baseSourceDbSchemaName = SpringUtils.getProperty((Environment)this.env, (String)"jdbc.source.db.base");
        Properties mavenProperties = this.mavenProject.getProperties();
        String version = this.mavenProject.getVersion();
        SetSourceDbSchemaNameExecutable executable = new SetSourceDbSchemaNameExecutable();
        executable.setBaseSourceDbSchemaName(baseSourceDbSchemaName);
        executable.setMavenProperties(mavenProperties);
        executable.setSkip(skip);
        executable.setVersion(version);
        return executable;
    }
}

