/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.project;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.project.maven.DirectoryContext;
import org.kuali.common.jute.project.maven.DirectoryPair;

public final class DirectoryContextProvider
implements Provider<DirectoryContext> {
    private final MavenProject project;

    @Inject
    public DirectoryContextProvider(MavenProject project) {
        this.project = (MavenProject)Precondition.checkNotNull((Object)project, (String)"project");
    }

    public DirectoryContext get() {
        Build build = this.project.getBuild();
        File mainSource = new File(build.getSourceDirectory());
        File mainOutput = new File(build.getOutputDirectory());
        File testSource = new File(build.getTestSourceDirectory());
        File testOutput = new File(build.getTestOutputDirectory());
        DirectoryContext.Builder builder = DirectoryContext.builder();
        builder.withBasedir(this.project.getBasedir());
        builder.withMain(DirectoryPair.build((File)mainSource, (File)mainOutput));
        builder.withTest(DirectoryPair.build((File)testSource, (File)testOutput));
        return builder.build();
    }

    public MavenProject getProject() {
        return this.project;
    }
}

