/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.project;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.project.maven.Dependency;
import org.kuali.common.jute.project.maven.DependencyScope;
import org.kuali.common.jute.project.maven.Exclusion;
import org.kuali.common.jute.project.maven.License;
import org.kuali.common.jute.project.maven.MavenScm;
import org.kuali.common.jute.project.maven.ProjectIdentifier;

public final class MavenFunctions {
    private static final String DEFAULT_SCM_TAG = "HEAD";

    private MavenFunctions() {
    }

    public static Function<MavenProject, ProjectIdentifier> projectIdentifierFunction() {
        return ProjectIdentifierFunction.INSTANCE;
    }

    public static Function<License, org.kuali.common.jute.project.maven.License> licenseFunction() {
        return LicenseFunction.INSTANCE;
    }

    public static Function<Scm, MavenScm> scmFunction() {
        return ScmFunction.INSTANCE;
    }

    public static Function<org.apache.maven.model.Dependency, Dependency> dependencyFunction() {
        return DependencyFunction.INSTANCE;
    }

    private static enum ExclusionFunction implements Function<Exclusion, org.kuali.common.jute.project.maven.Exclusion>
    {
        INSTANCE;


        public org.kuali.common.jute.project.maven.Exclusion apply(Exclusion input) {
            Exclusion.Builder builder = org.kuali.common.jute.project.maven.Exclusion.builder();
            builder.withGroupId(input.getGroupId());
            builder.withArtifactId(input.getArtifactId());
            return builder.build();
        }
    }

    private static enum DependencyFunction implements Function<org.apache.maven.model.Dependency, Dependency>
    {
        INSTANCE;


        public Dependency apply(org.apache.maven.model.Dependency input) {
            Dependency.Builder builder = Dependency.builder();
            builder.withGroupId(input.getGroupId());
            builder.withArtifactId(input.getArtifactId());
            builder.withVersion(input.getVersion());
            builder.withExclusions(Lists.transform((List)input.getExclusions(), (Function)ExclusionFunction.INSTANCE));
            builder.withOptional(Boolean.parseBoolean(input.getOptional()));
            if (StringUtils.isNotBlank((CharSequence)input.getScope())) {
                builder.withScope(DependencyScope.valueOf((String)input.getScope().toUpperCase()));
            }
            builder.withSystemPath(Optionals.fromTrimToNull((String)input.getSystemPath()));
            builder.withType(input.getType());
            return builder.build();
        }
    }

    private static enum ScmFunction implements Function<Scm, MavenScm>
    {
        INSTANCE;


        public MavenScm apply(Scm input) {
            MavenScm.Builder builder = MavenScm.builder();
            builder.withConnection(Optionals.fromTrimToNull((String)input.getConnection()));
            builder.withDeveloperConnection(Optionals.fromTrimToNull((String)input.getDeveloperConnection()));
            if (!MavenFunctions.DEFAULT_SCM_TAG.equals(StringUtils.trimToNull((String)input.getTag()))) {
                builder.withTag(Optionals.fromTrimToNull((String)input.getTag()));
            }
            builder.withUrl(Optionals.fromTrimToNull((String)input.getUrl()));
            return builder.build();
        }
    }

    private static enum LicenseFunction implements Function<License, org.kuali.common.jute.project.maven.License>
    {
        INSTANCE;


        public org.kuali.common.jute.project.maven.License apply(License input) {
            License.Builder builder = org.kuali.common.jute.project.maven.License.builder();
            builder.withComments(Optionals.fromTrimToNull((String)input.getComments()));
            builder.withName(Optionals.fromTrimToNull((String)input.getName()));
            builder.withUrl(Optionals.fromTrimToNull((String)input.getUrl()));
            return builder.build();
        }
    }

    private static enum ProjectIdentifierFunction implements Function<MavenProject, ProjectIdentifier>
    {
        INSTANCE;


        public ProjectIdentifier apply(MavenProject input) {
            return ProjectIdentifier.build((String)input.getGroupId(), (String)input.getArtifactId());
        }
    }
}

