/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.project;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.kuali.common.jute.collect.ImmutableProperties;
import org.kuali.common.jute.env.Environment;
import org.kuali.common.jute.env.Environments;
import org.kuali.common.jute.env.filter.KeyValues;
import org.kuali.common.jute.env.filter.PredicateProvider;
import org.kuali.common.jute.env.filter.annotation.AbsentDetector;
import org.kuali.common.jute.env.filter.annotation.CsvSplitter;
import org.kuali.common.jute.project.maven.DirectoryContext;
import org.kuali.common.jute.project.maven.MavenEnvironment;
import org.kuali.common.jute.project.maven.Project;
import org.kuali.common.jute.project.maven.annotation.EnvPrefix;
import org.kuali.common.jute.project.maven.annotation.ProjectProperties;
import org.kuali.common.maven.project.DirectoryContextProvider;
import org.kuali.common.maven.project.ProjectProvider;
import org.kuali.common.maven.project.annotation.PropertyPredicate;

public class MavenModule
extends AbstractModule {
    protected void configure() {
        this.bindConstant().annotatedWith(EnvPrefix.class).to("env");
        this.bind(MavenEnvironment.class).toProvider(MavenEnvironment.Builder.class);
        this.bind(DirectoryContext.class).toProvider(DirectoryContextProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<CharSequence>>(){}).annotatedWith(AbsentDetector.class).toInstance((Object)Environments.absentDetector());
        this.bind(Project.class).toProvider(ProjectProvider.class);
    }

    @Provides
    @ProjectProperties
    private Properties projectProperties(MavenProject project) {
        return ImmutableProperties.copyOf((Properties)project.getProperties());
    }

    @Provides
    @PropertyPredicate
    private Predicate<CharSequence> predicateProvider(MavenEnvironment env, @CsvSplitter Splitter splitter, @AbsentDetector Predicate<CharSequence> absentDetector) {
        String prefix = "project.metadata";
        KeyValues includes = KeyValues.build((String)(prefix + ".includes"), (String)"^project\\.id");
        KeyValues excludes = KeyValues.build((String)(prefix + ".excludes"));
        PredicateProvider.Builder builder = PredicateProvider.builder();
        builder.withAbsentDetector(absentDetector);
        builder.withIncludes(includes);
        builder.withExcludes(excludes);
        builder.withEnv((Environment)env);
        builder.withSplitter(splitter);
        return builder.build().get();
    }
}

