/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.project;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.project.maven.MavenScm;
import org.kuali.common.jute.project.maven.Project;
import org.kuali.common.jute.project.maven.ProjectCoordinates;
import org.kuali.common.maven.project.MavenFunctions;
import org.kuali.common.maven.project.annotation.PropertyPredicate;

public final class ProjectProvider
implements Provider<Project> {
    private final MavenProject project;
    private final Predicate<CharSequence> propertyPredicate;

    @Inject
    public ProjectProvider(MavenProject project, @PropertyPredicate Predicate<CharSequence> propertyPredicate) {
        this.project = (MavenProject)Precondition.checkNotNull((Object)project, (String)"project");
        this.propertyPredicate = (Predicate)Precondition.checkNotNull(propertyPredicate, (String)"propertyPredicate");
    }

    public Project get() {
        Project.Builder builder = Project.builder();
        builder.withCoordinates(this.getCoordinates(this.project));
        if (this.project.getParent() != null) {
            builder.withParent(Optional.of((Object)this.getCoordinates(this.project.getParent())));
        }
        builder.withEncoding(this.getEncoding(this.project));
        if (this.project.getDependencies() != null) {
            builder.withDependencies(Lists.transform((List)this.project.getDependencies(), MavenFunctions.dependencyFunction()));
        }
        builder.withDescription(Optionals.fromTrimToNull((String)this.project.getDescription()));
        builder.withInceptionYear(Optionals.fromTrimToNull((String)this.project.getInceptionYear()));
        if (this.project.getLicenses() != null) {
            builder.withLicenses(Lists.transform((List)this.project.getLicenses(), MavenFunctions.licenseFunction()));
        }
        builder.withName(Optionals.fromTrimToNull((String)this.project.getName()));
        if (StringUtils.isNotBlank((CharSequence)this.project.getPackaging())) {
            builder.withPackaging(this.project.getPackaging());
        }
        if (this.project.getProperties() != null) {
            Properties filtered = ProjectProvider.filterProperties(this.project.getProperties(), this.propertyPredicate);
            builder.withProperties(filtered);
        }
        if (this.project.getScm() != null) {
            MavenScm scm = (MavenScm)MavenFunctions.scmFunction().apply((Object)this.project.getScm());
            builder.withScm(Optional.of((Object)scm));
        }
        builder.withUrl(Optionals.fromTrimToNull((String)this.project.getUrl()));
        return builder.build();
    }

    private static Properties filterProperties(Properties props, Predicate<CharSequence> predicate) {
        Iterable keys = Iterables.filter(props.stringPropertyNames(), predicate);
        Properties filtered = new Properties();
        for (String key : keys) {
            String value = props.getProperty(key);
            filtered.setProperty(key, value);
        }
        return filtered;
    }

    private String getEncoding(MavenProject project) {
        Properties props = project.getProperties();
        if (props == null) {
            return Charset.defaultCharset().name();
        }
        String v1 = props.getProperty("project.build.sourceEncoding");
        String v2 = props.getProperty("project.encoding");
        String v3 = Charset.defaultCharset().name();
        if (StringUtils.isNotBlank((CharSequence)v1)) {
            return v1;
        }
        if (StringUtils.isNotBlank((CharSequence)v2)) {
            return v2;
        }
        return v3;
    }

    private ProjectCoordinates getCoordinates(MavenProject project) {
        ProjectCoordinates.Builder builder = ProjectCoordinates.builder();
        builder.withGroupId(project.getGroupId());
        builder.withArtifactId(project.getArtifactId());
        builder.withVersion(project.getVersion());
        return builder.build();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Predicate<CharSequence> getPropertyPredicate() {
        return this.propertyPredicate;
    }
}

