/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Str;

public class CollectionUtils {
    public static int[] getDivideEvenly(int number, int howManyWays) {
        Assert.isTrue((howManyWays > 0 ? 1 : 0) != 0, (String)"howManyWays must be a positive integer");
        int quotient = number / howManyWays;
        int remainder = number % howManyWays;
        int[] lengths = new int[howManyWays];
        for (int i = 0; i < howManyWays; ++i) {
            int length;
            lengths[i] = length = i < remainder ? quotient + 1 : quotient;
        }
        return lengths;
    }

    public static final <T> List<List<T>> splitEvenly(List<T> elements, int howManyWays) {
        if (howManyWays > elements.size()) {
            howManyWays = elements.size();
        }
        int[] lengths = CollectionUtils.getDivideEvenly(elements.size(), howManyWays);
        int offset = 0;
        ArrayList<List<T>> listOfLists = new ArrayList<List<T>>();
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            ArrayList<T> sublist = new ArrayList<T>();
            for (int j = offset; j < offset + length; ++j) {
                sublist.add(elements.get(j));
            }
            listOfLists.add(sublist);
            offset += length;
        }
        return listOfLists;
    }

    public static final List<String> getSequencedStrings(List<String> strings, int initialSequenceNumber) {
        ArrayList<String> sequencedStrings = new ArrayList<String>();
        int size = strings.size();
        int length = new Integer(size).toString().length();
        String prefix = StringUtils.repeat((String)"0", (int)length);
        for (String string : strings) {
            String sequence = StringUtils.right((String)(prefix + initialSequenceNumber++), (int)length);
            String sequencedString = sequence + "-" + string;
            sequencedStrings.add(sequencedString);
        }
        return sequencedStrings;
    }

    public static final List<String> getSequencedStrings(List<String> strings) {
        return CollectionUtils.getSequencedStrings(strings, 0);
    }

    public static final List<String> getUniqueStrings(List<String> strings) {
        ArrayList<String> unique = new ArrayList<String>();
        for (String string : strings) {
            if (unique.contains(string)) continue;
            unique.add(string);
        }
        return unique;
    }

    public static final List<File> getUniqueFiles(List<File> files) {
        ArrayList<String> strings = new ArrayList<String>();
        for (File file : files) {
            strings.add(LocationUtils.getCanonicalPath(file));
        }
        List<String> uniqueStrings = CollectionUtils.getUniqueStrings(strings);
        ArrayList<File> uniqueFiles = new ArrayList<File>();
        for (String uniqueString : uniqueStrings) {
            uniqueFiles.add(new File(uniqueString));
        }
        return uniqueFiles;
    }

    public static final List<String> getLines(String s) {
        if (s == null) {
            return Collections.emptyList();
        }
        try {
            return IOUtils.readLines((Reader)new StringReader(s));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final List<String> combineStringsUniquely(List<String> list1, List<String> list2) {
        List<String> newList = CollectionUtils.getUniqueStrings(list1);
        for (String element : list2) {
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    protected static final <T> T getNewInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final <T> List<T> getNewList(Class<T> c, int size) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T element = CollectionUtils.getNewInstance(c);
            list.add(element);
        }
        return list;
    }

    public static final <T> List<T> getList(List<Boolean> includes, List<T> list) {
        Assert.isTrue((includes.size() == list.size() ? 1 : 0) != 0);
        ArrayList<T> included = new ArrayList<T>();
        for (int i = 0; i < includes.size(); ++i) {
            if (!includes.get(i).booleanValue()) continue;
            included.add(list.get(i));
        }
        return included;
    }

    public static final <T> List<T> combineLists(List<List<T>> listOfLists) {
        ArrayList<T> combined = new ArrayList<T>();
        for (List<T> list : listOfLists) {
            combined.addAll(list);
        }
        return combined;
    }

    public static final <K, V> Map<K, V> combineMaps(List<Map<K, V>> listOfMaps) {
        HashMap<K, V> combined = new HashMap<K, V>();
        for (Map<K, V> map : listOfMaps) {
            combined.putAll(map);
        }
        return combined;
    }

    public static final <T> List<T> combine(T element, List<T> list) {
        Assert.notNull(element, (String)"element is required");
        if (list == null) {
            return Collections.singletonList(element);
        }
        ArrayList<T> combined = new ArrayList<T>();
        combined.add(element);
        for (T optional : list) {
            combined.add(optional);
        }
        return combined;
    }

    public static final <T> List<T> toEmptyList(T o) {
        if (o == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(o);
    }

    public static final <T> List<T> toEmptyList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static final <T> List<T> toNullIfEmpty(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list;
    }

    public static final <T> Collection<T> toNullIfEmpty(Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return null;
        }
        return c;
    }

    public static final <T> List<T> getPreFilledList(int size, T value) {
        if (value == null || size < 1) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(value);
        }
        return list;
    }

    public static final String getCSV(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < CollectionUtils.toEmptyList(strings).size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(strings.get(i));
        }
        return sb.toString();
    }

    public static final String getSpaceSeparatedString(List<?> list) {
        list = CollectionUtils.toEmptyList(list);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(list.get(i).toString());
        }
        return sb.toString();
    }

    public static final Object[] toObjectArray(List<Object> objects) {
        return objects.toArray(new Object[objects.size()]);
    }

    public static final String[] toStringArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    public static final boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static final List<String> sortedMerge(List<String> list, String csv) {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(CollectionUtils.toEmptyList(list));
        set.addAll(CollectionUtils.getTrimmedListFromCSV(csv));
        return new ArrayList<String>(set);
    }

    public static final List<String> getTrimmedListFromCSV(String csv) {
        if (StringUtils.isBlank((CharSequence)csv)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] tokens = Str.splitAndTrimCSV(csv);
        list.addAll(Arrays.asList(tokens));
        return list;
    }

    public static final List<String> combineStrings(List<String> list1, List<String> list2, List<String> list3) {
        ArrayList<String> combined = new ArrayList<String>();
        CollectionUtils.nullSafeAdd(combined, list1);
        CollectionUtils.nullSafeAdd(combined, list2);
        CollectionUtils.nullSafeAdd(combined, list3);
        return combined;
    }

    public static final List<String> combineStrings(List<String> list1, String string, List<String> list2) {
        return CollectionUtils.combineStrings(list1, CollectionUtils.toEmptyList(string), list2);
    }

    public static final List<String> combineStrings(List<String> list1, List<String> list2) {
        return CollectionUtils.combineStrings(list1, (String)null, list2);
    }

    public static final <T> void nullSafeAdd(List<T> list1, List<T> list2) {
        if (list2 != null) {
            list1.addAll(list2);
        }
    }

    public static final boolean containsAny(String s, List<String> strings) {
        for (String string : strings) {
            if (!StringUtils.contains((CharSequence)s, (CharSequence)string)) continue;
            return true;
        }
        return false;
    }
}

