/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.obscure.DefaultObscurer;
import org.kuali.common.util.obscure.Obscurer;
import org.slf4j.Logger;

public class LoggerUtils {
    private static final Obscurer DEFAULT_OBSCURER = new DefaultObscurer();

    public static int[] getPadding(List<String> columns, List<Object[]> argsList) {
        int[] padding = new int[columns.size()];
        for (int i = 0; i < padding.length; ++i) {
            padding[i] = Math.max(padding[i], columns.get(i).length());
        }
        for (Object[] args : argsList) {
            Assert.isTrue((columns.size() == args.length ? 1 : 0) != 0, (String)"Column count must equals args.length");
            for (int i = 0; i < args.length; ++i) {
                padding[i] = Math.max(padding[i], args[i].toString().length());
            }
        }
        return padding;
    }

    public static String getHeader(List<String> columns, int[] padding) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sb.append("  ");
            }
            sb.append(StringUtils.leftPad((String)columns.get(i), (int)padding[i]));
        }
        return sb.toString();
    }

    public static String getMsg(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sb.append("  ");
            }
            sb.append("{}");
        }
        return sb.toString();
    }

    public static void updateArgsList(List<Object[]> argsList, int[] padding) {
        for (Object[] args : argsList) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = StringUtils.leftPad((String)args[i].toString(), (int)padding[i]);
            }
        }
    }

    public static void logTable(List<String> columns, List<Object[]> argsList, LoggerLevel level, Logger logger) {
        int[] padding = LoggerUtils.getPadding(columns, argsList);
        LoggerUtils.logMsg(LoggerUtils.getHeader(columns, padding), logger, level);
        String msg = LoggerUtils.getMsg(padding.length);
        LoggerUtils.updateArgsList(argsList, padding);
        for (Object[] args : argsList) {
            LoggerUtils.logMsg(msg, args, logger, level);
        }
    }

    public static void logLines(String s, Logger logger, LoggerLevel level) {
        String[] lines;
        if (s == null) {
            return;
        }
        for (String line : lines = StringUtils.split((String)s, (String)"\n")) {
            LoggerUtils.logMsg(line, logger, level);
        }
    }

    public static final void logMsg(String msg, Object[] args, Logger logger, LoggerLevel level) {
        switch (level) {
            case DEBUG: {
                logger.debug(msg, args);
                return;
            }
            case TRACE: {
                logger.trace(msg, args);
                return;
            }
            case INFO: {
                logger.info(msg, args);
                return;
            }
            case WARN: {
                logger.warn(msg, args);
                return;
            }
            case ERROR: {
                logger.error(msg, args);
                return;
            }
        }
        throw new IllegalArgumentException("Logger level " + (Object)((Object)level) + " is unknown");
    }

    public static final void logMsg(String msg, Logger logger, LoggerLevel level) {
        LoggerUtils.logMsg(msg, null, logger, level);
    }

    public static final String getUsername(String username) {
        return LoggerUtils.getNullAsNone(username);
    }

    public static final String getNullAsNone(String string) {
        if (string == null) {
            return "NONE";
        }
        return string;
    }

    public static final String getPassword(String username, String password) {
        return LoggerUtils.getPassword(username, password, DEFAULT_OBSCURER);
    }

    public static boolean isNullOrNone(String s) {
        if (s == null) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"NONE", (CharSequence)s)) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"NULL", (CharSequence)s);
    }

    public static final String getPassword(String username, String password, Obscurer obscurer) {
        if (LoggerUtils.isNullOrNone(password)) {
            return "NONE";
        }
        if (StringUtils.equals((CharSequence)username, (CharSequence)password)) {
            return password;
        }
        return obscurer.obscure(password);
    }
}

