/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.PrintStream;
import org.kuali.common.util.Assert;

public class PercentCompleteInformer {
    protected long progress;
    PrintStream printStream = System.out;
    int percentageIncrement = 1;
    int percentCompletePrevious;
    String startToken = "[INFO] Progress: ";
    String progressToken = ".";
    String completeToken = "\n";
    long total;

    public PercentCompleteInformer() {
        this(0L);
    }

    public PercentCompleteInformer(long total) {
        this.total = total;
    }

    public synchronized long getProgress() {
        return this.progress;
    }

    public synchronized void incrementProgress() {
        this.incrementProgress(1L);
    }

    public synchronized void incrementProgress(long amount) {
        this.progress += amount;
        int percentComplete = (int)(this.progress * 100L / this.total);
        if (this.isEnoughProgress(percentComplete, this.percentCompletePrevious, this.percentageIncrement)) {
            this.percentCompletePrevious = percentComplete;
            this.printStream.print(this.progressToken);
        }
    }

    protected boolean isEnoughProgress(int percentComplete, int percentCompletePrevious, int percentageIncrement) {
        int needed = percentCompletePrevious + percentageIncrement;
        return percentComplete >= needed;
    }

    public void start() {
        Assert.notNull((Object)this.printStream, (String)"printStream is null");
        this.printStream.print(this.startToken);
    }

    public void stop() {
        this.printStream.print(this.completeToken);
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public int getPercentageIncrement() {
        return this.percentageIncrement;
    }

    public void setPercentageIncrement(int percentageIncrement) {
        this.percentageIncrement = percentageIncrement;
    }

    public String getStartToken() {
        return this.startToken;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public String getCompleteToken() {
        return this.completeToken;
    }

    public void setCompleteToken(String completeToken) {
        this.completeToken = completeToken;
    }

    public String getProgressToken() {
        return this.progressToken;
    }

    public void setProgressToken(String progressToken) {
        this.progressToken = progressToken;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

