/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ComparisonResults;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.GlobalPropertiesMode;
import org.kuali.common.util.property.processor.AddPropertiesProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final String XML_EXTENSION = ".xml";
    private static final String ENV_PREFIX = "env";
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private static final String DEFAULT_XML_ENCODING = "UTF-8";

    public static void decrypt(Properties properties, TextEncryptor encryptor) {
        PropertyUtils.decrypt(properties, encryptor, null, null);
    }

    public static Properties getEncryptedProperties(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        Properties encrypted = new Properties();
        for (String key : keys) {
            String value = properties.getProperty(key);
            if (!PropertyUtils.isEncryptedPropertyValue(value)) continue;
            encrypted.setProperty(key, value);
        }
        return encrypted;
    }

    public static void decrypt(Properties properties, TextEncryptor encryptor, List<String> includes, List<String> excludes) {
        List<String> keys = PropertyUtils.getSortedKeys(properties, includes, excludes);
        for (String key : keys) {
            String value = properties.getProperty(key);
            if (!PropertyUtils.isEncryptedPropertyValue(value)) continue;
            String decryptedValue = PropertyUtils.decryptPropertyValue(encryptor, value);
            properties.setProperty(key, decryptedValue);
        }
    }

    public static boolean isEncryptedPropertyValue(String value) {
        return StringUtils.startsWith((CharSequence)value, (CharSequence)"ENC(") && StringUtils.endsWith((CharSequence)value, (CharSequence)")");
    }

    public static void encrypt(Properties properties, TextEncryptor encryptor) {
        PropertyUtils.encrypt(properties, encryptor, null, null);
    }

    public static void encrypt(Properties properties, TextEncryptor encryptor, List<String> includes, List<String> excludes) {
        List<String> keys = PropertyUtils.getSortedKeys(properties, includes, excludes);
        for (String key : keys) {
            String originalValue = properties.getProperty(key);
            String encryptedValue = PropertyUtils.encryptPropertyValue(encryptor, originalValue);
            properties.setProperty(key, encryptedValue);
        }
    }

    public static String decryptPropertyValue(TextEncryptor encryptor, String value) {
        Assert.isTrue((boolean)StringUtils.startsWith((CharSequence)value, (CharSequence)"ENC("), (String)"value does not start with ENC(");
        Assert.isTrue((boolean)StringUtils.endsWith((CharSequence)value, (CharSequence)")"), (String)"value does not end with )");
        int start = "ENC(".length();
        int end = StringUtils.length((CharSequence)value) - ")".length();
        String unwrapped = StringUtils.substring((String)value, (int)start, (int)end);
        return encryptor.decrypt(unwrapped);
    }

    public static String encryptPropertyValue(TextEncryptor encryptor, String value) {
        String encryptedValue = encryptor.encrypt(value);
        StringBuilder sb = new StringBuilder();
        sb.append("ENC(");
        sb.append(encryptedValue);
        sb.append(")");
        return sb.toString();
    }

    public static void overrideWithGlobalValues(Properties properties, GlobalPropertiesMode mode) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        Properties global = PropertyUtils.getProperties(mode);
        for (String key : keys) {
            String globalValue = global.getProperty(key);
            if (StringUtils.isBlank((CharSequence)globalValue)) continue;
            properties.setProperty(key, globalValue);
        }
    }

    public static final Properties combine(List<Properties> properties) {
        Properties combined = new Properties();
        for (Properties p : properties) {
            combined.putAll((Map<?, ?>)PropertyUtils.toEmpty(p));
        }
        return combined;
    }

    public static final Properties combine(Properties ... properties) {
        return PropertyUtils.combine(Arrays.asList(properties));
    }

    public static final void process(Properties properties, PropertyProcessor processor) {
        PropertyUtils.process(properties, Collections.singletonList(processor));
    }

    public static final void process(Properties properties, List<PropertyProcessor> processors) {
        for (PropertyProcessor processor : CollectionUtils.toEmptyList(processors)) {
            processor.process(properties);
        }
    }

    public static final Properties toEmpty(Properties properties) {
        return properties == null ? new Properties() : properties;
    }

    public static final boolean isSingleUnresolvedPlaceholder(String string) {
        return PropertyUtils.isSingleUnresolvedPlaceholder(string, "${", "}");
    }

    public static final boolean isSingleUnresolvedPlaceholder(String string, String prefix, String suffix) {
        int prefixMatches = StringUtils.countMatches((CharSequence)string, (CharSequence)prefix);
        int suffixMatches = StringUtils.countMatches((CharSequence)string, (CharSequence)suffix);
        boolean startsWith = StringUtils.startsWith((CharSequence)string, (CharSequence)prefix);
        boolean endsWith = StringUtils.endsWith((CharSequence)string, (CharSequence)suffix);
        return prefixMatches == 1 && suffixMatches == 1 && startsWith && endsWith;
    }

    public static final boolean containsUnresolvedPlaceholder(String string) {
        return PropertyUtils.containsUnresolvedPlaceholder(string, "${", "}");
    }

    public static final boolean containsUnresolvedPlaceholder(String string, String prefix, String suffix) {
        int beginIndex = StringUtils.indexOf((CharSequence)string, (CharSequence)prefix);
        if (beginIndex == -1) {
            return false;
        }
        return StringUtils.indexOf((CharSequence)string, (CharSequence)suffix) != -1;
    }

    public static final Properties getResolvedProperties(Properties properties) {
        return PropertyUtils.getResolvedProperties(properties, Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER, Constants.DEFAULT_GLOBAL_PROPERTIES_MODE);
    }

    public static final Properties getResolvedProperties(Properties properties, GlobalPropertiesMode globalPropertiesMode) {
        return PropertyUtils.getResolvedProperties(properties, Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER, globalPropertiesMode);
    }

    public static final Properties getResolvedProperties(Properties properties, PropertyPlaceholderHelper helper) {
        return PropertyUtils.getResolvedProperties(properties, helper, Constants.DEFAULT_GLOBAL_PROPERTIES_MODE);
    }

    public static final Properties getResolvedProperties(Properties properties, PropertyPlaceholderHelper helper, GlobalPropertiesMode globalPropertiesMode) {
        Properties global = PropertyUtils.getProperties(properties, globalPropertiesMode);
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        Properties newProperties = new Properties();
        for (String key : keys) {
            String originalValue = properties.getProperty(key);
            String resolvedValue = helper.replacePlaceholders(originalValue, global);
            if (resolvedValue.equals(originalValue)) continue;
            logger.debug("Resolved property '" + key + "' [{}] -> [{}]", (Object)Str.flatten(originalValue), (Object)Str.flatten(resolvedValue));
            newProperties.setProperty(key, resolvedValue);
        }
        return newProperties;
    }

    public static final List<String> getValues(Properties properties, List<String> keys) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : keys) {
            values.add(properties.getProperty(key));
        }
        return values;
    }

    public static final List<String> getEndsWithKeys(Properties properties, String suffix) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        ArrayList<String> matches = new ArrayList<String>();
        for (String key : keys) {
            if (!StringUtils.endsWith((CharSequence)key, (CharSequence)suffix)) continue;
            matches.add(key);
        }
        return matches;
    }

    public static final void trim(Properties properties, String includesCSV, String excludesCSV) {
        List<String> includes = CollectionUtils.getTrimmedListFromCSV(includesCSV);
        List<String> excludes = CollectionUtils.getTrimmedListFromCSV(excludesCSV);
        PropertyUtils.trim(properties, includes, excludes);
    }

    public static final void trim(Properties properties, List<String> includes, List<String> excludes) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        for (String key : keys) {
            if (PropertyUtils.include(key, includes, excludes)) continue;
            logger.debug("Removing [{}]", (Object)key);
            properties.remove(key);
        }
    }

    public static final boolean include(String value, List<String> includes, List<String> excludes) {
        if (PropertyUtils.isSingleWildcardMatch(value, excludes)) {
            return false;
        }
        return CollectionUtils.isEmpty(includes) || PropertyUtils.isSingleWildcardMatch(value, includes);
    }

    public static final boolean isSingleWildcardMatch(String s, List<String> patterns) {
        for (String pattern : CollectionUtils.toEmptyList(patterns)) {
            if (!PropertyUtils.isSingleWildcardMatch(s, pattern)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isSingleWildcardMatch(String value, String pattern) {
        if (value == null && pattern == null) {
            return true;
        }
        if (value != null && pattern == null || value == null && pattern != null) {
            return false;
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (StringUtils.countMatches((CharSequence)pattern, (CharSequence)"*") > 1) {
            throw new IllegalArgumentException("Pattern [" + pattern + "] is not supported.  Only one wildcard is allowed in the pattern");
        }
        if (!StringUtils.contains((CharSequence)pattern, (CharSequence)"*")) {
            return StringUtils.equals((CharSequence)value, (CharSequence)pattern);
        }
        int pos = StringUtils.indexOf((CharSequence)pattern, (CharSequence)"*");
        int suffixPos = pos + "*".length();
        boolean nullPrefix = pos == 0;
        boolean nullSuffix = suffixPos >= pattern.length();
        String prefix = nullPrefix ? null : StringUtils.substring((String)pattern, (int)0, (int)pos);
        String suffix = nullSuffix ? null : StringUtils.substring((String)pattern, (int)suffixPos);
        boolean prefixMatch = nullPrefix || StringUtils.startsWith((CharSequence)value, (CharSequence)prefix);
        boolean suffixMatch = nullSuffix || StringUtils.endsWith((CharSequence)value, (CharSequence)suffix);
        return prefixMatch && suffixMatch;
    }

    public static final Properties getProperties(Properties properties, String include, String exclude) {
        List<String> keys = PropertyUtils.getSortedKeys(properties, include, exclude);
        Properties newProperties = new Properties();
        for (String key : keys) {
            String value = properties.getProperty(key);
            newProperties.setProperty(key, value);
        }
        return newProperties;
    }

    public static final List<String> getSortedKeys(Properties properties, String include, String exclude) {
        return PropertyUtils.getSortedKeys(properties, CollectionUtils.toEmptyList(include), CollectionUtils.toEmptyList(exclude));
    }

    public static final List<String> getSortedKeys(Properties properties, List<String> includes, List<String> excludes) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        ArrayList<String> includedKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!PropertyUtils.include(key, includes, excludes)) continue;
            includedKeys.add(key);
        }
        return includedKeys;
    }

    public static final List<String> getStartsWithKeys(Properties properties, String prefix) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        ArrayList<String> matches = new ArrayList<String>();
        for (String key : keys) {
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            matches.add(key);
        }
        return matches;
    }

    public static final List<String> getSortedKeys(Properties properties) {
        ArrayList<String> keys = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(keys);
        return keys;
    }

    public static final String toString(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = Str.flatten(properties.getProperty(key));
            sb.append(key + "=" + value + "\n");
        }
        return sb.toString();
    }

    public static final void info(Properties properties) {
        properties = PropertyUtils.toEmpty(properties);
        logger.info("--- Displaying {} properties ---\n\n{}", (Object)properties.size(), (Object)PropertyUtils.toString(properties));
    }

    public static final void debug(Properties properties) {
        properties = PropertyUtils.toEmpty(properties);
        logger.debug("--- Displaying {} properties ---\n\n{}", (Object)properties.size(), (Object)PropertyUtils.toString(properties));
    }

    public static final void store(Properties properties, File file) {
        PropertyUtils.store(properties, file, null);
    }

    public static final void store(Properties properties, File file, String encoding) {
        PropertyUtils.store(properties, file, encoding, null);
    }

    public static final void store(Properties properties, File file, String encoding, String comment) {
        Writer writer;
        FileOutputStream out;
        block7: {
            out = null;
            writer = null;
            try {
                out = FileUtils.openOutputStream((File)file);
                String path = file.getCanonicalPath();
                boolean xml = PropertyUtils.isXml(path);
                SortedProperties sorted = PropertyUtils.getSortedProperties(properties);
                comment = PropertyUtils.getComment(encoding, comment, xml);
                if (xml) {
                    logger.info("Storing XML properties - [{}] encoding={}", (Object)path, (Object)StringUtils.defaultIfBlank((CharSequence)encoding, (CharSequence)DEFAULT_ENCODING));
                    if (encoding == null) {
                        sorted.storeToXML(out, comment);
                    } else {
                        sorted.storeToXML((OutputStream)out, comment, encoding);
                    }
                    break block7;
                }
                writer = LocationUtils.getWriter(out, encoding);
                logger.info("Storing properties - [{}] encoding={}", (Object)path, (Object)StringUtils.defaultIfBlank((CharSequence)encoding, (CharSequence)DEFAULT_ENCODING));
                sorted.store(writer, comment);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("Unexpected IO error", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)out);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static final Properties getGlobalProperties() {
        return PropertyUtils.getProperties(Constants.DEFAULT_GLOBAL_PROPERTIES_MODE);
    }

    public static final Properties getGlobalProperties(Properties properties) {
        return PropertyUtils.getProperties(properties, Constants.DEFAULT_GLOBAL_PROPERTIES_MODE);
    }

    public static final Properties getProperties(Properties properties, GlobalPropertiesMode mode) {
        Properties newProperties = PropertyUtils.duplicate(properties);
        List<PropertyProcessor> modifiers = PropertyUtils.getPropertyProcessors(mode);
        for (PropertyProcessor modifier : modifiers) {
            modifier.process(newProperties);
        }
        return newProperties;
    }

    public static final Properties getProperties(GlobalPropertiesMode mode) {
        return PropertyUtils.getProperties(new Properties(), mode);
    }

    public static final String getProperty(String key, GlobalPropertiesMode mode) {
        return PropertyUtils.getProperty(key, new Properties(), mode);
    }

    public static final String getProperty(String key, Properties properties, GlobalPropertiesMode mode) {
        return PropertyUtils.getProperties(properties, mode).getProperty(key);
    }

    public static final List<PropertyProcessor> getPropertyProcessors(GlobalPropertiesMode mode) {
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        switch (mode) {
            case NONE: {
                return processors;
            }
            case ENVIRONMENT: {
                processors.add(new AddPropertiesProcessor(PropertyUtils.getEnvAsProperties()));
                return processors;
            }
            case SYSTEM: {
                processors.add(new AddPropertiesProcessor(System.getProperties()));
                return processors;
            }
            case BOTH: {
                processors.add(new AddPropertiesProcessor(PropertyUtils.getEnvAsProperties()));
                processors.add(new AddPropertiesProcessor(System.getProperties()));
                return processors;
            }
        }
        throw new IllegalStateException((Object)((Object)mode) + " is unknown");
    }

    public static final Properties convert(Map<String, String> map) {
        Properties props = new Properties();
        for (String key : map.keySet()) {
            String value = map.get(key);
            props.setProperty(key, value);
        }
        return props;
    }

    public static final Properties duplicate(Properties properties) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        return newProperties;
    }

    public static Properties getEnvAsProperties() {
        return PropertyUtils.getEnvAsProperties(ENV_PREFIX);
    }

    public static Properties getEnvAsProperties(String prefix) {
        Properties properties = PropertyUtils.convert(System.getenv());
        return PropertyUtils.getPrefixedProperties(properties, prefix);
    }

    public static final boolean isXml(String location) {
        return StringUtils.endsWithIgnoreCase((CharSequence)location, (CharSequence)XML_EXTENSION);
    }

    public static final Properties load(File file) {
        return PropertyUtils.load(file, null);
    }

    public static final Properties load(File file, String encoding) {
        String location = LocationUtils.getCanonicalPath(file);
        return PropertyUtils.load(location, encoding);
    }

    public static final Properties load(String location) {
        return PropertyUtils.load(location, null);
    }

    public static final Properties load(String location, String encoding) {
        Properties properties;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            Properties properties2 = new Properties();
            boolean xml = PropertyUtils.isXml(location);
            location = PropertyUtils.getCanonicalLocation(location);
            if (xml) {
                in = LocationUtils.getInputStream(location);
                logger.info("Loading XML properties - [{}]", (Object)location);
                properties2.loadFromXML(in);
            } else {
                logger.info("Loading properties - [{}] encoding={}", (Object)location, (Object)StringUtils.defaultIfBlank((CharSequence)encoding, (CharSequence)DEFAULT_ENCODING));
                reader = LocationUtils.getBufferedReader(location, encoding);
                properties2.load(reader);
            }
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unexpected IO error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((Reader)reader);
        return properties;
    }

    protected static String getCanonicalLocation(String location) {
        if (LocationUtils.isExistingFile(location)) {
            return LocationUtils.getCanonicalPath(new File(location));
        }
        return location;
    }

    public static final Properties getPrefixedProperties(Properties properties, String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return PropertyUtils.duplicate(properties);
        }
        Properties newProperties = new Properties();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            String newKey = StringUtils.startsWith((CharSequence)key, (CharSequence)(prefix + ".")) ? key : prefix + "." + key;
            newProperties.setProperty(newKey, value);
        }
        return newProperties;
    }

    public static final Properties reformatKeysAsEnvVars(Properties properties) {
        Properties newProperties = new Properties();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            String newKey = StringUtils.upperCase((String)StringUtils.replace((String)key, (String)".", (String)"-"));
            newProperties.setProperty(newKey, value);
        }
        return newProperties;
    }

    public static final void addOrOverrideProperty(Properties properties, String key, String newValue, Mode propertyOverwriteMode) {
        String oldValue = properties.getProperty(key);
        if (StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) {
            return;
        }
        boolean overwrite = !StringUtils.isBlank((CharSequence)oldValue);
        String logNewValue = newValue;
        String logOldValue = oldValue;
        if (PropertyUtils.obscure(key)) {
            logNewValue = "PROTECTED";
            logOldValue = "PROTECTED";
        }
        if (overwrite) {
            Object[] args = new Object[]{key, Str.flatten(logNewValue), Str.flatten(logOldValue)};
            ModeUtils.validate(propertyOverwriteMode, "Overriding [{}={}] was [{}]", args, "Override of existing property [" + key + "] is not allowed.");
        } else {
            logger.info("Adding [{}={}]", (Object)key, (Object)Str.flatten(logNewValue));
        }
        properties.setProperty(key, newValue);
    }

    protected static boolean obscure(String key) {
        if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)".password")) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)".secret")) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)".private");
    }

    private static final String getDefaultComment(String encoding, boolean xml) {
        if (encoding == null) {
            if (xml) {
                return "encoding.default=UTF-8";
            }
            return "encoding.default=" + DEFAULT_ENCODING;
        }
        return "encoding.specified=" + encoding;
    }

    private static final String getComment(String encoding, String comment, boolean xml) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return PropertyUtils.getDefaultComment(encoding, xml);
        }
        return comment + "\n#" + PropertyUtils.getDefaultComment(encoding, xml);
    }

    private static final SortedProperties getSortedProperties(Properties properties) {
        PropertyUtils propertyUtils = new PropertyUtils();
        propertyUtils.getClass();
        SortedProperties sp = propertyUtils.new SortedProperties();
        sp.putAll((Map<?, ?>)properties);
        return sp;
    }

    public static final void addListComparisonProperties(Properties properties, ComparisonResults listComparison, List<String> propertyNames) {
        Assert.isTrue((propertyNames.size() == 3 ? 1 : 0) != 0);
        properties.setProperty(propertyNames.get(0), CollectionUtils.getCSV(listComparison.getAdded()));
        properties.setProperty(propertyNames.get(1), CollectionUtils.getCSV(listComparison.getSame()));
        properties.setProperty(propertyNames.get(2), CollectionUtils.getCSV(listComparison.getDeleted()));
    }

    private class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1330825236411537386L;

        private SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

