/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Artifact;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.nullify.NullUtils;

public class RepositoryUtils {
    private static final String FS = File.separator;
    private static final String DEFAULT_MAVEN_REPO_PATH = ".m2" + FS + "repository";

    public static final void copyArtifact(String repository, Artifact artifact) {
        File file = RepositoryUtils.getFile(artifact);
        RepositoryUtils.copyArtifactToFile(repository, artifact, file);
    }

    public static final void copyArtifactToDirectory(String repository, Artifact artifact, File directory) {
        String filename = RepositoryUtils.getFilename(artifact);
        File file = new File(directory, filename);
        RepositoryUtils.copyArtifactToFile(repository, artifact, file);
    }

    public static final void copyArtifactToFile(String repository, Artifact artifact, File file) {
        String location = repository + RepositoryUtils.getRepositoryPath(artifact);
        LocationUtils.copyLocationToFile(location, file);
    }

    public static final String toString(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append(":");
        sb.append(artifact.getArtifactId());
        sb.append(":");
        sb.append(artifact.getVersion());
        if (!RepositoryUtils.isSkipClassifier(artifact)) {
            sb.append(":");
            sb.append(artifact.getClassifier());
        }
        sb.append(":");
        sb.append(artifact.getPackaging());
        return sb.toString();
    }

    protected static boolean isSkipClassifier(Artifact artifact) {
        return StringUtils.isBlank((CharSequence)artifact.getClassifier()) || NullUtils.isNullOrNone(artifact.getClassifier());
    }

    public static final String getRepositoryPath(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(Str.getPath(artifact.getGroupId()));
        sb.append(FS);
        sb.append(artifact.getArtifactId());
        sb.append(FS);
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static final String getFilename(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId());
        sb.append("-");
        sb.append(artifact.getVersion());
        if (!RepositoryUtils.isSkipClassifier(artifact)) {
            sb.append(":");
            sb.append(artifact.getClassifier());
        }
        sb.append(".");
        sb.append(artifact.getPackaging());
        return sb.toString();
    }

    public static final File getDefaultLocalRepositoryDir() {
        return new File(FileUtils.getUserDirectoryPath() + FS + DEFAULT_MAVEN_REPO_PATH);
    }

    public static final File getFile(Artifact artifact) {
        return RepositoryUtils.getFile(RepositoryUtils.getDefaultLocalRepositoryDir(), artifact);
    }

    public static final File getFile(File localRepositoryDir, Artifact artifact) {
        String path = RepositoryUtils.getRepositoryPath(artifact);
        String filename = RepositoryUtils.getFilename(artifact);
        return new File(localRepositoryDir.getAbsolutePath() + FS + path, filename);
    }
}

