/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;

public class UnixCmds {
    private static final String SU = "su";
    private static final String MKDIR = "mkdir";
    private static final String RM = "rm";
    private static final String CHOWN = "chown";
    private static final String CHMOD = "chmod";

    public String chmod(String mode, String path) {
        Assert.notBlank(path);
        return this.chmod(mode, Collections.singletonList(path));
    }

    public String chmod(String mode, List<String> paths) {
        return this.chmod(null, mode, paths);
    }

    public String chmod(List<String> options, String mode, List<String> paths) {
        Assert.hasLength((String)mode);
        Assert.notEmpty(paths);
        return this.cmd(CHMOD, CollectionUtils.combineStrings(options, mode, paths));
    }

    public String mkdirp(String path) {
        Assert.notBlank(path);
        return this.mkdirp(null, Collections.singletonList(path));
    }

    public String mkdirp(List<String> paths) {
        return this.mkdirp(null, paths);
    }

    public String mkdirp(List<String> options, List<String> paths) {
        List<String> parents = Arrays.asList("-p");
        if (options == null) {
            return this.mkdir(parents, paths);
        }
        return this.mkdir(CollectionUtils.combineStringsUniquely(options, parents), paths);
    }

    public String mkdir(String path) {
        Assert.notBlank(path);
        return this.mkdir(null, Collections.singletonList(path));
    }

    public String mkdir(List<String> options, List<String> paths) {
        Assert.notEmpty(paths);
        return this.cmd(MKDIR, CollectionUtils.combineStrings(options, paths));
    }

    public String su(String login, String command) {
        return this.su(null, login, command);
    }

    public String su(List<String> options, String login, String command) {
        return this.su(options, login, Arrays.asList("--command", command));
    }

    public String su(List<String> options, String login, List<String> args) {
        List<String> list2 = login == null ? null : Arrays.asList("-", login);
        return this.cmd(SU, CollectionUtils.combineStrings(options, list2, args));
    }

    public String rmrf(List<String> paths) {
        return this.rmrf(null, paths);
    }

    public String rmrf(String path) {
        Assert.notBlank(path);
        return this.rmrf(null, Collections.singletonList(path));
    }

    public String rmrf(List<String> options, List<String> paths) {
        List<String> recursiveSilent = Arrays.asList("-r", "-f");
        if (options == null) {
            return this.rm(recursiveSilent, paths);
        }
        return this.rm(CollectionUtils.combineStringsUniquely(options, recursiveSilent), paths);
    }

    public String rm(List<String> paths) {
        return this.rm(null, paths);
    }

    public String rm(String path) {
        Assert.notBlank(path);
        return this.rm(null, Collections.singletonList(path));
    }

    public String rm(List<String> options, List<String> paths) {
        Assert.notEmpty(paths);
        return this.cmd(RM, CollectionUtils.combineStrings(options, paths));
    }

    public String chownr(String owner, String group, String path) {
        Assert.notBlank(path);
        return this.chownr(owner, group, Collections.singletonList(path));
    }

    public String chownr(String owner, String group, List<String> paths) {
        return this.chownr(null, owner, group, paths);
    }

    public String chownr(List<String> options, String owner, String group, List<String> paths) {
        List<String> recursive = Arrays.asList("-R");
        if (options == null) {
            return this.chown(recursive, owner, group, paths);
        }
        return this.chown(CollectionUtils.combineStringsUniquely(options, recursive), owner, group, paths);
    }

    public String chown(List<String> options, String owner, String group, String path) {
        Assert.notBlank(path);
        return this.chown(options, owner, group, Collections.singletonList(path));
    }

    public String chown(List<String> options, String owner, String group, List<String> paths) {
        Assert.notEmpty(paths);
        Assert.notBlank(owner, group);
        return this.cmd(CHOWN, CollectionUtils.combineStrings(options, owner + ":" + group, paths));
    }

    public String chown(String owner, String group, String path) {
        Assert.notBlank(path);
        return this.chown(null, owner, group, Collections.singletonList(path));
    }

    public String cmd(String executable, List<String> args) {
        StringBuilder sb = new StringBuilder();
        sb.append(executable);
        if (!CollectionUtils.isEmpty(args)) {
            sb.append(" ");
            sb.append(CollectionUtils.getSpaceSeparatedString(args));
        }
        return sb.toString();
    }
}

