/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.nullify;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.nullify.Nullify;
import org.springframework.util.Assert;

public class DefaultBeanNullifier
implements Nullify {
    Object bean;
    List<String> properties;
    List<String> nullTokens = Collections.singletonList("NULL");
    boolean caseSensitive = false;

    @Override
    public void nullify() {
        Assert.notNull((Object)this.bean, (String)"bean cannot be null");
        Assert.notNull(this.properties, (String)"properties cannot be null");
        Assert.notNull(this.nullTokens, (String)"nullTokens cannot be null");
        for (String property : this.properties) {
            Object value = this.getProperty(this.bean, property);
            if (!this.isNullify(value, this.nullTokens, this.caseSensitive)) continue;
            this.setProperty(this.bean, property, null);
        }
    }

    protected boolean isNullify(Object value, List<String> nullTokens, boolean caseSensitive) {
        if (value == null) {
            return false;
        }
        return Str.contains(nullTokens, value.toString(), caseSensitive);
    }

    protected void setProperty(Object bean, String property, Object value) {
        try {
            PropertyUtils.setProperty((Object)bean, (String)property, (Object)value);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Object getProperty(Object bean, String property) {
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getNullTokens() {
        return this.nullTokens;
    }

    public void setNullTokens(List<String> nullTokens) {
        this.nullTokens = nullTokens;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

