/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CustomerLoadXMLSchemaTest
extends TestCase {
    private static final String XML_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String XML_SAMPLE_FILE = "CustomerLoad-Sample.xml";
    private static final String SCHEMA_DIRECTORY = "work/web-root/static/xsd/ar/";
    private static final String SCHEMA_FILE = "customer.xsd";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNothing() {
    }

    public void NORUN_testSampleAgainstSchema() throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("org/kuali/kfs/module/ar/batch/sample/CustomerLoad-Sample.xml");
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
        ByteArrayInputStream sampleXmlFile = new ByteArrayInputStream(byteArray);
        File schemaFile = new File("work/web-root/static/xsd/ar/customer.xsd");
        CustomerLoadXMLSchemaTest.assertTrue((String)"File should exist at the specified path.", (boolean)schemaFile.exists());
        inputStream = new FileInputStream(schemaFile);
        byteArray = IOUtils.toByteArray((InputStream)inputStream);
        ByteArrayInputStream schemaLocation = new ByteArrayInputStream(byteArray);
        this.validateContentsAgainstSchema(schemaLocation, sampleXmlFile);
    }

    private void validateContentsAgainstSchema(InputStream schemaLocation, InputStream fileContents) throws ParseException, MalformedURLException, IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = null;
        schemaSource = new StreamSource(schemaLocation);
        Schema schema = null;
        schema = factory.newSchema(schemaSource);
        Validator validator = schema.newValidator();
        validator.setErrorHandler((ErrorHandler)new XmlErrorHandler());
        validator.validate(new StreamSource(fileContents));
    }
}

