/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARProposalFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDocumentFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceGeneralDetailFixture;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.ReflectionMap;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsInvoiceDocumentTest
extends KualiTestBase {
    private BusinessObjectService businessObjectService;
    public CostCategory category;
    public ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument;
    public ContractsGrantsInvoiceDocumentServiceImpl contractsGrantsInvoiceDocumentServiceImpl;
    ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentServiceImpl;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.contractsGrantsInvoiceDocumentServiceImpl = new ContractsGrantsInvoiceDocumentServiceImpl();
        this.contractsGrantsInvoiceDocumentServiceImpl.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceDocumentServiceImpl.setObjectCodeService((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setAccountingPeriodService((AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setAwardAccountObjectCodeTotalBilledDao((AwardAccountObjectCodeTotalBilledDao)SpringContext.getBean(AwardAccountObjectCodeTotalBilledDao.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setDateTimeService((DateTimeService)SpringContext.getBean(DateTimeService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)this.contractsGrantsInvoiceDocumentServiceImpl);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setCostCategoryService((CostCategoryService)SpringContext.getBean(CostCategoryService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        this.category = new CostCategory();
        this.category.setCategoryCode("testCode");
        this.category.setCategoryName("testName");
        CostCategoryObjectCode costCategoryObjectCode = new CostCategoryObjectCode();
        costCategoryObjectCode.setCategoryCode("testCode");
        costCategoryObjectCode.setChartOfAccountsCode("BL");
        costCategoryObjectCode.setFinancialObjectCode("5000");
        this.category.setObjectCodes(new ArrayList());
        this.category.getObjectCodes().add(costCategoryObjectCode);
        this.contractsGrantsInvoiceDocument = new ContractsGrantsInvoiceDocument();
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testUpdateLastBilledDate() {
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_1 = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_2 = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        org.kuali.kfs.integration.cg.businessobject.Proposal proposal = ARProposalFixture.CG_PRPSL1.createProposal();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_2.createAwardAccount();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccounts.add((ContractsAndGrantsBillingAwardAccount)awardAccount_1);
        awardAccounts.add((ContractsAndGrantsBillingAwardAccount)awardAccount_2);
        this.setAwardAccountsToAward(award.getProposalNumber(), awardAccounts);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument_1.setAccountDetails(accountDetails);
        accountDetails = new ArrayList();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL4.createInvoiceAccountDetail();
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument_2.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail_1 = InvoiceGeneralDetailFixture.INV_GNRL_DTL3.createInvoiceGeneralDetail();
        InvoiceGeneralDetail invoiceGeneralDetail_2 = InvoiceGeneralDetailFixture.INV_GNRL_DTL3.createInvoiceGeneralDetail();
        invoiceGeneralDetail_1.setAward(award);
        invoiceGeneralDetail_2.setAward(award);
        Date lastBilledDate_1 = Date.valueOf("2011-10-26");
        Date lastBilledDate_2 = Date.valueOf("2011-10-27");
        invoiceGeneralDetail_1.setLastBilledDate(lastBilledDate_1);
        invoiceGeneralDetail_2.setLastBilledDate(lastBilledDate_2);
        contractsGrantsInvoiceDocument_1.setInvoiceGeneralDetail(invoiceGeneralDetail_1);
        contractsGrantsInvoiceDocument_2.setInvoiceGeneralDetail(invoiceGeneralDetail_2);
        contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        contractsGrantsInvoiceDocumentService.updateLastBilledDate(contractsGrantsInvoiceDocument_1);
        HashMap<String, Object> mapKey = new HashMap<String, Object>();
        mapKey.put("accountNumber", awardAccount_1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", awardAccount_1.getProposalNumber());
        ContractsAndGrantsBillingAwardAccount awdAcct_1 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        mapKey.put("accountNumber", awardAccount_2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_2.getChartOfAccountsCode());
        ContractsAndGrantsBillingAwardAccount awdAcct_2 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)lastBilledDate_1, (Object)awdAcct_1.getCurrentLastBilledDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals(null, (Object)awdAcct_2.getCurrentLastBilledDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals(null, (Object)award.getLastBilledDate());
        contractsGrantsInvoiceDocument_2.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        contractsGrantsInvoiceDocumentService.updateLastBilledDate(contractsGrantsInvoiceDocument_2);
        mapKey = new HashMap();
        mapKey.put("accountNumber", awardAccount_1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", awardAccount_1.getProposalNumber());
        awdAcct_1 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        mapKey.put("accountNumber", awardAccount_2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_2.getChartOfAccountsCode());
        awdAcct_2 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)lastBilledDate_1, (Object)awdAcct_1.getCurrentLastBilledDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)lastBilledDate_2, (Object)awdAcct_2.getCurrentLastBilledDate());
        mapKey.clear();
        mapKey.put("proposalNumber", award.getProposalNumber());
        contractsGrantsInvoiceDocument_2.getInvoiceGeneralDetail().setAward(null);
        award = (ContractsAndGrantsBillingAward)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, mapKey);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)lastBilledDate_1, (Object)award.getLastBilledDate());
        contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        contractsGrantsInvoiceDocument_1.getFinancialSystemDocumentHeader().setFinancialDocumentInErrorNumber(contractsGrantsInvoiceDocument_2.getDocumentNumber());
        contractsGrantsInvoiceDocument_1.isInvoiceReversal();
        contractsGrantsInvoiceDocumentService.updateLastBilledDate(contractsGrantsInvoiceDocument_1);
        mapKey = new HashMap();
        mapKey.put("accountNumber", awardAccount_1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", awardAccount_1.getProposalNumber());
        awdAcct_1 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        mapKey.put("accountNumber", awardAccount_2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", awardAccount_2.getChartOfAccountsCode());
        awdAcct_2 = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
        ContractsGrantsInvoiceDocumentTest.assertEquals(null, (Object)awdAcct_1.getCurrentLastBilledDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)lastBilledDate_2, (Object)awdAcct_2.getCurrentLastBilledDate());
        mapKey.clear();
        mapKey.put("proposalNumber", award.getProposalNumber());
        award = (ContractsAndGrantsBillingAward)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, mapKey);
        ContractsGrantsInvoiceDocumentTest.assertEquals(null, (Object)award.getLastBilledDate());
    }

    private void setAwardAccountsToAward(Long proposalNumber, List<ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        Proposal proposal = (Proposal)this.businessObjectService.findBySinglePrimaryKey(Proposal.class, (Object)proposalNumber);
        if (ObjectUtils.isNull((Object)proposal)) {
            proposal = new Proposal();
            proposal.setProposalNumber(proposalNumber);
        }
        this.businessObjectService.save((PersistableBusinessObject)proposal);
        Award award = (Award)this.businessObjectService.findBySinglePrimaryKey(Award.class, (Object)proposalNumber);
        if (ObjectUtils.isNull((Object)award)) {
            award = new Award();
            award.setProposalNumber(proposalNumber);
        }
        this.businessObjectService.save((PersistableBusinessObject)award);
        ArrayList<AwardAccount> awdAccts = new ArrayList<AwardAccount>();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            HashMap<String, Object> mapKey = new HashMap<String, Object>();
            mapKey.put("accountNumber", awardAccount.getAccountNumber());
            mapKey.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
            mapKey.put("proposalNumber", awardAccount.getProposalNumber());
            AwardAccount awdAcct = (AwardAccount)this.businessObjectService.findByPrimaryKey(AwardAccount.class, mapKey);
            if (ObjectUtils.isNull((Object)awdAcct)) {
                awdAcct = new AwardAccount();
                awdAcct.setAccountNumber(awardAccount.getAccountNumber());
                awdAcct.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
                awdAcct.setProposalNumber(awardAccount.getProposalNumber());
            }
            this.businessObjectService.save((PersistableBusinessObject)awdAcct);
            awdAccts.add(awdAcct);
        }
        award.setAwardAccounts(awdAccts);
    }

    public void testInvoiceDetails() {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        invoiceGeneralDetail.setProposalNumber(award.getProposalNumber());
        this.contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL4.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL5.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_3 = ContractsGrantsInvoiceDetailFixture.INV_DTL6.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        invoiceDetails.add(invoiceDetail_3);
        this.contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        List generatedInvoiceDetails = this.contractsGrantsInvoiceCreateDocumentServiceImpl.generateValuesForCategories(this.contractsGrantsInvoiceDocument.getDocumentNumber(), this.contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes(), new HashMap(), new ArrayList());
        this.contractsGrantsInvoiceDocument.getInvoiceDetails().addAll(generatedInvoiceDetails);
        List allInvoiceDetails = this.contractsGrantsInvoiceDocument.getInvoiceDetails();
        List invoiceDetailsWithoutIdc = this.contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails();
        List invoiceDetailsIdcOnly = this.contractsGrantsInvoiceDocument.getIndirectCostInvoiceDetails();
        List invoiceDetailsWithIdc = this.contractsGrantsInvoiceDocument.getInvoiceDetails();
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail();
        ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalDirectCostInvoiceDetail();
        ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalIndirectCostInvoiceDetail();
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)12, (int)allInvoiceDetails.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)11, (int)invoiceDetailsWithoutIdc.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)1, (int)invoiceDetailsIdcOnly.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)12, (int)invoiceDetailsWithIdc.size());
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(960.0), (Object)totalCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(1020.0), (Object)totalCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-60.0), (Object)totalCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(960.0), (Object)totalCostInvoiceDetail.getAmountRemainingToBill());
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalDirectCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(640.0), (Object)totalDirectCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(680.0), (Object)totalDirectCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-40.0), (Object)totalDirectCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalDirectCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalDirectCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(640.0), (Object)totalDirectCostInvoiceDetail.getAmountRemainingToBill());
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalInDirectCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(320.0), (Object)totalInDirectCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(340.0), (Object)totalInDirectCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-20.0), (Object)totalInDirectCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalInDirectCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalInDirectCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(320.0), (Object)totalInDirectCostInvoiceDetail.getAmountRemainingToBill());
    }

    public void testCheckAwardContractControlAccounts_ValidNoInvoicingOption() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByAccount() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByContractControlAccount() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_CCA.createAward();
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1.createAwardAccount();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        awardAccounts.add(awardAccount_2);
        ((Award)award).setAwardAccounts(awardAccounts);
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByContractControlAccountNoCCA() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_CCA.createAward();
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.no.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(award.getInvoicingOptionDescription()));
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByAward() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_AWARD.createAward();
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1.createAwardAccount();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        awardAccounts.add(awardAccount_2);
        ((Award)award).setAwardAccounts(awardAccounts);
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByAwardNoCCA() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_AWARD.createAward();
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.no.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(award.getInvoicingOptionDescription()));
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByAwardMultipleCCAs() throws Exception {
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_INV_AWARD.createAward();
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1.createAwardAccount();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_3.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        awardAccounts.add(awardAccount_2);
        ((Award)award).setAwardAccounts(awardAccounts);
        this.refreshAccounts(award);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(award);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.multiple.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(award.getInvoicingOptionDescription()));
    }

    private void refreshAccounts(ContractsAndGrantsBillingAward award) {
        List awardAccounts = award.getActiveAwardAccounts();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            ((AwardAccount)awardAccount).refreshReferenceObject("account");
        }
    }

    public void testBeanMapVersionOfDocument() {
        ContractsGrantsInvoiceDocument cinvDoc = new ContractsGrantsInvoiceDocument();
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber(new Long(80075L));
        cinvDoc.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAccountDetail invoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail);
        cinvDoc.setAccountDetails(accountDetails);
        ReflectionMap map = new ReflectionMap((Object)cinvDoc);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new Long(80075L), map.get("invoiceGeneralDetail.proposalNumber"));
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)"MILE", map.get("invoiceGeneralDetail.billingFrequencyCode"));
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)"9000000", map.get("accountDetails[0].accountNumber"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("zebra"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("invoiceGeneralDetail.zebra"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("accountDetails[2].accountNumber"));
    }
}

