/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceItemCodeFixture;
import org.kuali.kfs.module.ar.fixture.OrganizationAccountingDefaultFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDetailServiceTest
extends KualiTestBase {
    public void testGetCustomerInvoiceDetailFromCustomerInvoiceItemCode() {
        CustomerInvoiceItemCode customerInvoiceItemCode = CustomerInvoiceItemCodeFixture.BASE_CIIC.createCustomerInvoiceItemCode();
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)customerInvoiceItemCode);
        CustomerInvoiceDetailService service = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
        CustomerInvoiceDetail customerInvoiceDetail = service.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(CustomerInvoiceItemCodeFixture.BASE_CIIC.invoiceItemCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.chartOfAccountsCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.organizationCode);
        CustomerInvoiceDetailServiceTest.assertEquals((String)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceChartOfAccountsCode, (String)customerInvoiceDetail.getChartOfAccountsCode());
        CustomerInvoiceDetailServiceTest.assertEquals((String)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceAccountNumber, (String)customerInvoiceDetail.getAccountNumber());
        CustomerInvoiceDetailServiceTest.assertEquals((String)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceFinancialObjectCode, (String)customerInvoiceDetail.getFinancialObjectCode());
    }

    public void testGetCustomerInvoiceDetailFromOrganizationAccountingDefault() {
        OrganizationAccountingDefault orgAcctDefault = OrganizationAccountingDefaultFixture.BASE_OAD.createOrganizationAccountingDefault();
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)orgAcctDefault);
        CustomerInvoiceDetailService service = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
        CustomerInvoiceDetail customerInvoiceDetail = service.getCustomerInvoiceDetailFromOrganizationAccountingDefault(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear(), OrganizationAccountingDefaultFixture.BASE_OAD.chartOfAccountsCode, OrganizationAccountingDefaultFixture.BASE_OAD.organizationCode);
        CustomerInvoiceDetailServiceTest.assertEquals((String)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceChartOfAccountsCode, (String)customerInvoiceDetail.getChartOfAccountsCode());
        CustomerInvoiceDetailServiceTest.assertEquals((String)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceAccountNumber, (String)customerInvoiceDetail.getAccountNumber());
        CustomerInvoiceDetailServiceTest.assertEquals((String)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceFinancialObjectCode, (String)customerInvoiceDetail.getFinancialObjectCode());
    }
}

