/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.Date;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.batch.service.impl.VerifyBillingFrequencyServiceImpl;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.ConfigurableDateTimeServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class VerifyBillingFrequencyServiceTest
extends KualiTestBase {
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    private AccountingPeriodService accountingPeriodService;

    public void setUp() throws Exception {
        super.setUp();
        this.verifyBillingFrequencyService = new VerifyBillingFrequencyServiceImpl();
        this.accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        ((VerifyBillingFrequencyServiceImpl)this.verifyBillingFrequencyService).setBusinessObjectService((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class));
        ((VerifyBillingFrequencyServiceImpl)this.verifyBillingFrequencyService).setAccountingPeriodService(this.accountingPeriodService);
        ((VerifyBillingFrequencyServiceImpl)this.verifyBillingFrequencyService).setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
    }

    public void testMonthlyNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL, true);
    }

    public void testMilestoneNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_MILESTONE_BILLED_DATE_NULL, true);
    }

    public void testPredeterminedBillingNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_NULL, true);
    }

    public void testQuarterlyNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_QUAR_BILLED_DATE_NULL, true);
    }

    public void testSemiAnnualNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-06-30", ARAwardFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_NULL, true);
    }

    public void testAnnualNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-06-30", ARAwardFixture.CG_AWARD_ANNUAL_BILLED_DATE_NULL, true);
    }

    public void testMonthValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID, true);
    }

    public void testMilestoneValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_MILESTONE_BILLED_DATE_VALID, true);
    }

    public void testPredeterminedValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_VALID, true);
    }

    public void testQuarterlyValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-04-01", "2011-09-30", ARAwardFixture.CG_AWARD_QUAR_BILLED_DATE_VALID, true);
    }

    public void testSemiAnnualBillingValidLastBilledDate() {
        this.runBillingTest("2012-01-01", "2011-01-01", "2011-12-31", ARAwardFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_VALID, true);
    }

    public void testAnnualBillingValidLastBilledDate() {
        this.runBillingTest("2011-07-01", "2009-07-01", "2011-06-30", ARAwardFixture.CG_AWARD_ANNUAL_BILLED_DATE_VALID, true);
    }

    public void testLOCBillingNullLastBilledDate() {
        this.runLOCBillingTest("2011-10-31", "2011-01-01", ARAwardFixture.CG_AWARD_LOCB_BILLED_DATE_NULL);
    }

    public void testLOCBillingValidLastBilledDate() {
        this.runLOCBillingTest("2011-12-15", "2010-12-13", ARAwardFixture.CG_AWARD_LOCB_BILLED_DATE_VALID);
    }

    protected void runLOCBillingTest(String currentDate, String startDate, ARAwardFixture awardFixture) {
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(java.sql.Date.valueOf(currentDate));
        ContractsAndGrantsBillingAward award = awardFixture.createAward();
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        dateTimeService.setCurrentDate((Date)java.sql.Date.valueOf(currentDate));
        ((VerifyBillingFrequencyServiceImpl)this.verifyBillingFrequencyService).setDateTimeService((DateTimeService)dateTimeService);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        VerifyBillingFrequencyServiceTest.assertEquals((Object)java.sql.Date.valueOf(startDate), (Object)billingPeriod.getStartDate());
    }

    protected void runBillingTest(String currentDate, String beginningDate, String endDate, ARAwardFixture awardFixture, boolean expectedWithinGracePeriod) {
        java.sql.Date date = java.sql.Date.valueOf(currentDate);
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(date);
        ContractsAndGrantsBillingAward award = awardFixture.createAward();
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        dateTimeService.setCurrentDate((Date)java.sql.Date.valueOf(currentDate));
        ((VerifyBillingFrequencyServiceImpl)this.verifyBillingFrequencyService).setDateTimeService((DateTimeService)dateTimeService);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        VerifyBillingFrequencyServiceTest.assertEquals((Object)java.sql.Date.valueOf(beginningDate), (Object)billingPeriod.getStartDate());
        VerifyBillingFrequencyServiceTest.assertEquals((Object)java.sql.Date.valueOf(endDate), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.verifyBillingFrequencyService.calculateIfWithinGracePeriod(date, billingPeriod.getEndDate(), billingPeriod.getStartDate(), award.getLastBilledDate(), new Integer(0).intValue());
        VerifyBillingFrequencyServiceTest.assertEquals((boolean)expectedWithinGracePeriod, (boolean)withinGracePeriod);
    }
}

