/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailUnitPriceValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDetailUnitPriceValidationTest
extends KualiTestBase {
    private CustomerInvoiceDetailUnitPriceValidation validation;

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new CustomerInvoiceDetailUnitPriceValidation();
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    public void testUnitPriceNotEqualToZero_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotEqualToZero_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_AMOUNT_EQUALS_ZERO.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotNegativeWhenReversalAndDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotNegativeWhenReversalAndDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotPositiveWhenReversalAndNotDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotPositiveWhenReversalAndNotDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotNegativeWhenNotReversalAndNotDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testUnitPriceNotNegativeWhenNotReversalAndNotDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailUnitPriceValidationTest.assertFalse((boolean)this.validation.validate(null));
    }
}

