/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.module.ar.batch.report.LockboxLoadResult;

public class LockboxLoadFileResult {
    private String filename;
    private List<String[]> messages;
    private Map lockboxMap;

    public LockboxLoadFileResult(String filename) {
        this.filename = filename;
        this.lockboxMap = new HashMap();
        this.messages = new ArrayList<String[]>();
    }

    public LockboxLoadResult getOrAddLockbox(String lockboxNumber, LockboxLoadResult result) {
        if (!this.lockboxMap.containsKey(lockboxNumber)) {
            this.lockboxMap.put(lockboxNumber, result);
        }
        return (LockboxLoadResult)this.lockboxMap.get(lockboxNumber);
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String[]> getMessages() {
        return this.messages;
    }

    public void addFileErrorMessage(String message) {
        this.messages.add(new String[]{LockboxLoadResult.getEntryTypeString(LockboxLoadResult.EntryType.ERROR), message});
    }

    public void addFileInfoMessage(String message) {
        this.messages.add(new String[]{LockboxLoadResult.getEntryTypeString(LockboxLoadResult.EntryType.INFO), message});
    }

    public Set<String> getLockboxNumbers() {
        return this.lockboxMap.keySet();
    }

    public LockboxLoadResult getLockbox(String lockboxNumber) {
        return (LockboxLoadResult)this.lockboxMap.get(lockboxNumber);
    }

    public Map getLockboxMap() {
        return this.lockboxMap;
    }

    public void setLockboxMap(Map lockboxMap) {
        this.lockboxMap = lockboxMap;
    }
}

