/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.CustomerAgingReportNotificationStep;
import org.kuali.kfs.module.ar.batch.service.CustomerNotificationService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.service.KfsNotificationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerNotificationServiceImpl
implements CustomerNotificationService {
    private static Logger LOG = Logger.getLogger(CustomerNotificationServiceImpl.class);
    private String agingReportTemplate;
    private BusinessObjectService businessObjectService;
    private CustomerInvoiceDocumentService customerInvoiceDocumentService;
    private KfsNotificationService kfsNotificationService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;

    @Override
    public void sendCustomerAgingReport() {
        Collection<CustomerInvoiceDocument> openAgingInvoiceDocuments = this.getQualifiedAgingInvoiceDocument();
        Timestamp agingReportSentTime = this.getDateTimeService().getCurrentTimestamp();
        for (CustomerInvoiceDocument invoiceDocument : openAgingInvoiceDocuments) {
            this.sendCustomerAgingReport(invoiceDocument, agingReportSentTime);
        }
    }

    @Override
    public void sendCustomerAgingReport(CustomerInvoiceDocument invoiceDocument, Timestamp agingReportSentTime) {
        if (ObjectUtils.isNotNull((Object)invoiceDocument)) {
            invoiceDocument.setAgingReportSentTime(agingReportSentTime);
            this.getBusinessObjectService().save((PersistableBusinessObject)invoiceDocument);
        }
        MailMessage mailMessage = this.buildAgingReportMailMessage(invoiceDocument);
        this.getKfsNotificationService().sendNotificationByMail(mailMessage);
    }

    protected Collection<CustomerInvoiceDocument> getQualifiedAgingInvoiceDocument() {
        Collection<Object> agingInvoiceDocuments = new ArrayList();
        Integer invoiceAge = this.getCustomerAgingNotificationOnDays();
        String selectionOption = this.getNotificationSelectionOption();
        if (StringUtils.equals((String)ArConstants.ArNotificationOptions.PROCESSING_ORG.option, (String)selectionOption)) {
            List<String> charts = this.getNotificationChartSelection();
            List<String> organizations = this.getNotificationOrganizationSelection();
            agingInvoiceDocuments = this.customerInvoiceDocumentService.getAllAgingInvoiceDocumentsByProcessing(charts, organizations, invoiceAge);
        } else if (StringUtils.equals((String)ArConstants.ArNotificationOptions.BILLING_ORG.option, (String)selectionOption)) {
            List<String> charts = this.getNotificationChartSelection();
            List<String> organizations = this.getNotificationOrganizationSelection();
            agingInvoiceDocuments = this.customerInvoiceDocumentService.getAllAgingInvoiceDocumentsByBilling(charts, organizations, invoiceAge);
        } else if (StringUtils.equals((String)ArConstants.ArNotificationOptions.ACCOUNT.option, (String)selectionOption)) {
            List<String> charts = this.getNotificationChartSelection();
            List<String> accounts = this.getNotificationAccountSelection();
            agingInvoiceDocuments = this.customerInvoiceDocumentService.getAllAgingInvoiceDocumentsByAccounts(charts, accounts, invoiceAge);
        } else {
            throw new RuntimeException("The given notification option only can be one of the following values: " + ArConstants.ArNotificationOptions.values());
        }
        return agingInvoiceDocuments;
    }

    protected MailMessage buildAgingReportMailMessage(CustomerInvoiceDocument invoiceDocument) {
        MailMessage mailMessage = new MailMessage();
        Customer customer = invoiceDocument.getCustomer();
        String senderEmailAddress = this.getNotificationSender();
        mailMessage.setFromAddress(senderEmailAddress);
        String customerEmailAddress = customer.getCustomerEmailAddress();
        mailMessage.addToAddress(customerEmailAddress);
        String notificationSubject = this.getNotificationSubject() + "[" + invoiceDocument.getCustomerName() + "]";
        mailMessage.setSubject(notificationSubject);
        String notificationBody = this.buildNotificationBody(invoiceDocument);
        mailMessage.setMessage(notificationBody);
        return mailMessage;
    }

    protected OrganizationOptions getOrganizationOptions(CustomerInvoiceDocument invoiceDocument) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", invoiceDocument.getBillByChartOfAccountCode());
        criteria.put("organizationCode", invoiceDocument.getBilledByOrganizationCode());
        return (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
    }

    protected String buildNotificationBody(CustomerInvoiceDocument invoiceDocument) {
        HashMap<String, Object> agingReportInformationHolder = new HashMap<String, Object>();
        Customer customer = invoiceDocument.getCustomer();
        String customerEmail = customer.getCustomerEmailAddress();
        OrganizationOptions organizationOptions = this.getOrganizationOptions(invoiceDocument);
        agingReportInformationHolder.put("customer", (Object)customer);
        agingReportInformationHolder.put("customerInvoiceDocument", invoiceDocument);
        agingReportInformationHolder.put("organizationOptions", (Object)organizationOptions);
        agingReportInformationHolder.put("notificationText", this.getNotificationText());
        this.updateAgingAmount(invoiceDocument, agingReportInformationHolder);
        return this.getKfsNotificationService().generateNotificationContent(this.getAgingReportTemplate(), agingReportInformationHolder);
    }

    protected void updateAgingAmount(CustomerInvoiceDocument invoiceDocument, Map<String, Object> agingReportInformationHolder) {
        agingReportInformationHolder.put("total0to30", KualiDecimal.ZERO);
        agingReportInformationHolder.put("total31to60", KualiDecimal.ZERO);
        agingReportInformationHolder.put("total61to90", KualiDecimal.ZERO);
        agingReportInformationHolder.put("total90toSYSPR", KualiDecimal.ZERO);
        Integer invoiceAge = invoiceDocument.getAge();
        KualiDecimal openAmount = invoiceDocument.getOpenAmount();
        if (invoiceAge <= 30) {
            agingReportInformationHolder.put("total0to30", openAmount);
        } else if (invoiceAge <= 60) {
            agingReportInformationHolder.put("total31to60", openAmount);
        } else if (invoiceAge <= 90) {
            agingReportInformationHolder.put("total61to90", openAmount);
        } else {
            agingReportInformationHolder.put("total90toSYSPR", openAmount);
        }
    }

    protected String getNotificationSender() {
        return this.getParameterService().getParameterValueAsString(CustomerAgingReportNotificationStep.class, "FROM_EMAIL_ADDRESS");
    }

    protected Integer getCustomerAgingNotificationOnDays() {
        String daysAsString = this.getParameterService().getParameterValueAsString(CustomerAgingReportNotificationStep.class, "NOTIFICATION_DAYS");
        if (!StringUtils.isNumeric((String)daysAsString)) {
            daysAsString = this.getParameterService().getParameterValueAsString(CustomerAgingReportDetail.class, "CUSTOMER_INVOICE_AGE");
        }
        return Integer.parseInt(daysAsString);
    }

    protected String getNotificationSelectionOption() {
        return this.getParameterService().getParameterValueAsString(CustomerAgingReportNotificationStep.class, "NOTIFICATION_SELECTION_TYPE");
    }

    protected List<String> getNotificationChartSelection() {
        return this.getNotificationSelection(ArConstants.ArNotificationSelectionField.CHART.fieldName);
    }

    protected List<String> getNotificationOrganizationSelection() {
        return this.getNotificationSelection(ArConstants.ArNotificationSelectionField.ORGANIZATION.fieldName);
    }

    protected List<String> getNotificationAccountSelection() {
        return this.getNotificationSelection(ArConstants.ArNotificationSelectionField.ACCOUNT.fieldName);
    }

    protected List<String> getNotificationSelection(String fieldName) {
        return new ArrayList<String>(this.getParameterService().getSubParameterValuesAsString(CustomerAgingReportNotificationStep.class, "NOTIFICATION_SELECTION", fieldName));
    }

    protected String getNotificationText() {
        return this.getParameterService().getParameterValueAsString(CustomerAgingReportNotificationStep.class, "NOTIFICATION_TEXT");
    }

    protected String getNotificationSubject() {
        return this.getParameterService().getParameterValueAsString(CustomerAgingReportNotificationStep.class, "NOTIFICATION_SUBJECT");
    }

    public String getAgingReportTemplate() {
        return this.agingReportTemplate;
    }

    public void setAgingReportTemplate(String agingReportTemplate) {
        this.agingReportTemplate = agingReportTemplate;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public KfsNotificationService getKfsNotificationService() {
        return this.kfsNotificationService;
    }

    public void setKfsNotificationService(KfsNotificationService kfsNotificationService) {
        this.kfsNotificationService = kfsNotificationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

