/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.ElectronicPaymentClaim;
import org.kuali.kfs.sys.service.ElectronicPaymentClaimingDocumentGenerationStrategy;
import org.kuali.kfs.sys.service.ElectronicPaymentClaimingService;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

public class CashControlElectronicPaymentClaimingHelperImpl
implements ElectronicPaymentClaimingDocumentGenerationStrategy {
    private static final Logger LOG = Logger.getLogger(CashControlElectronicPaymentClaimingHelperImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected DocumentService documentService;
    protected ElectronicPaymentClaimingService electronicPaymentClaimingService;
    protected CashControlDocumentService cashControlDocumentService;
    protected ConfigurationService kualiConfigurationService;
    protected FinancialSystemUserService financialSystemUserService;
    private static DocumentTypeService documentTypeService;
    private AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;

    public String createDocumentFromElectronicPayments(List<ElectronicPaymentClaim> electronicPayments, Person user) {
        CashControlDocument document = null;
        try {
            document = (CashControlDocument)this.documentService.getNewDocument(this.getClaimingDocumentWorkflowDocumentType());
            document.setCustomerPaymentMediumCode("WT");
            ChartOrgHolder currentUser = this.financialSystemUserService.getPrimaryOrganization(GlobalVariables.getUserSession().getPerson(), "KFS-AR");
            AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = this.accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
            accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
            document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
            this.addDescriptionToDocument(document);
            this.addNotesToDocument(document, electronicPayments, user);
            this.addCashControlDetailsToDocument(document, electronicPayments);
            this.documentService.saveDocument((Document)document);
            this.electronicPaymentClaimingService.claimElectronicPayments(electronicPayments, document.getDocumentNumber());
        }
        catch (WorkflowException we) {
            throw new RuntimeException("WorkflowException while creating a CashControlDocument to claim ElectronicPaymentClaim records.", we);
        }
        return this.getURLForDocument(document);
    }

    protected void addDescriptionToDocument(CashControlDocument document) {
        document.getDocumentHeader().setDocumentDescription(this.kualiConfigurationService.getPropertyValueAsString("message.ar.electronicPaymentClaim"));
    }

    protected void addNotesToDocument(CashControlDocument claimingDoc, List<ElectronicPaymentClaim> claims, Person user) {
        for (String noteText : this.electronicPaymentClaimingService.constructNoteTextsForClaims(claims)) {
            Note note = this.documentService.createNoteFromDocument((Document)claimingDoc, noteText);
            claimingDoc.addNote(note);
            this.documentService.saveDocumentNotes((Document)claimingDoc);
        }
    }

    protected void addCashControlDetailsToDocument(CashControlDocument document, List<ElectronicPaymentClaim> electronicPayments) throws WorkflowException {
        for (ElectronicPaymentClaim electronicPaymentClaim : electronicPayments) {
            CashControlDetail newCashControlDetail = new CashControlDetail();
            newCashControlDetail.setCashControlDocument(document);
            newCashControlDetail.setDocumentNumber(document.getDocumentNumber());
            newCashControlDetail.setFinancialDocumentLineAmount(electronicPaymentClaim.getGeneratingAccountingLine().getAmount());
            newCashControlDetail.setCustomerPaymentDescription(electronicPaymentClaim.getGeneratingAccountingLine().getFinancialDocumentLineDescription());
            this.cashControlDocumentService.addNewCashControlDetail(this.kualiConfigurationService.getPropertyValueAsString("message.ar.createdByCashControlDocument"), document, newCashControlDetail);
        }
    }

    protected String getURLForDocument(CashControlDocument doc) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayActionListView");
        parameters.put("docId", doc.getDocumentNumber());
        return UrlFactory.parameterizeUrl((String)"arCashControlDocument.do", (Properties)parameters);
    }

    public String getClaimingDocumentWorkflowDocumentType() {
        return "CTRL";
    }

    public String getDocumentLabel() {
        return this.getDocumentTypeService().getDocumentTypeByName(this.getClaimingDocumentWorkflowDocumentType()).getLabel();
    }

    public boolean isDocumentReferenceValid(String referenceDocumentNumber) {
        boolean isValid = false;
        try {
            long docNumberAsLong = Long.parseLong(referenceDocumentNumber);
            if (docNumberAsLong > 0L) {
                isValid = this.documentService.documentExists(referenceDocumentNumber);
            }
        }
        catch (NumberFormatException nfe) {
            isValid = false;
        }
        return isValid;
    }

    public boolean userMayUseToClaim(Person claimingUser) {
        String documentTypeName = this.getClaimingDocumentWorkflowDocumentType();
        boolean canClaim = this.electronicPaymentClaimingService.isAuthorizedForClaimingElectronicPayment(claimingUser, documentTypeName) || this.electronicPaymentClaimingService.isAuthorizedForClaimingElectronicPayment(claimingUser, null);
        return canClaim;
    }

    public void setCashControlDocumentService(CashControlDocumentService cashControlDocumentService) {
        this.cashControlDocumentService = cashControlDocumentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setElectronicPaymentClaimingService(ElectronicPaymentClaimingService electronicPaymentClaimingService) {
        this.electronicPaymentClaimingService = electronicPaymentClaimingService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public DocumentTypeService getDocumentTypeService() {
        if (documentTypeService == null) {
            documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return documentTypeService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }
}

