/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopyFields;
import com.lowagie.text.pdf.PdfReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityType;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.DunningLetterTemplate;
import org.kuali.kfs.module.ar.businessobject.GenerateDunningLettersLookupResult;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.PdfFormFillerUtil;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DunningLetterServiceImpl
implements DunningLetterService {
    protected static Logger LOG = Logger.getLogger(DunningLetterServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected DateTimeService dateTimeService;
    protected FinancialSystemUserService financialSystemUserService;
    protected KualiModuleService kualiModuleService;
    protected NoteService noteService;
    private ParameterService parameterService;

    protected byte[] createDunningLetters(DunningLetterTemplate dunningLetterTemplate, GenerateDunningLettersLookupResult dunningLetterDistributionLookupResult) {
        ArrayList<ContractsGrantsInvoiceDocument> selectedInvoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        byte[] reportStream = null;
        byte[] finalReportStream = null;
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)((Object)dunningLetterTemplate)) && dunningLetterTemplate.isActive() && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) {
            for (ContractsGrantsInvoiceDocument cgInvoice : dunningLetterDistributionLookupResult.getInvoices()) {
                if (!StringUtils.equals((String)cgInvoice.getInvoiceGeneralDetail().getDunningLetterTemplateAssigned(), (String)dunningLetterTemplate.getDunningLetterTemplateCode())) continue;
                selectedInvoices.add(cgInvoice);
                CollectionEvent event = new CollectionEvent();
                event.setInvoiceNumber(cgInvoice.getDocumentNumber());
                event.setCollectionEventCode(cgInvoice.getNextCollectionEventCode());
                String activityCode = this.parameterService.getParameterValueAsString(CollectionActivityType.class, "DUNNING_LETTER_GENERATION_CODE");
                if (StringUtils.isNotBlank((String)activityCode)) {
                    event.setActivityCode(activityCode);
                    event.setActivityDate(new Date(new java.util.Date().getTime()));
                    event.setActivityText("Dunning Letter has been sent to sponsor.");
                    Timestamp now = this.dateTimeService.getCurrentTimestamp();
                    event.setPostedDate(now);
                    if (GlobalVariables.getUserSession() != null && GlobalVariables.getUserSession().getPerson() != null) {
                        Person authorUniversal = GlobalVariables.getUserSession().getPerson();
                        event.setUserPrincipalId(authorUniversal.getPrincipalId());
                        event.setUser(authorUniversal);
                    }
                    this.businessObjectService.save((PersistableBusinessObject)event);
                    cgInvoice.getCollectionEvents().add(event);
                }
                cgInvoice.getInvoiceGeneralDetail().setDunningLetterTemplateSentDate(new Date(new java.util.Date().getTime()));
                this.businessObjectService.save((PersistableBusinessObject)cgInvoice);
            }
            ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
            String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
            String templateFilePath = templateFolderPath + File.separator + dunningLetterTemplate.getFilename();
            File templateFile = new File(templateFilePath);
            Object outputDirectory = null;
            try {
                String outputFileName = dunningLetterDistributionLookupResult.getProposalNumber() + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".pdf";
                Map<String, String> replacementList = this.getTemplateParameterList(selectedInvoices);
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("customerNumber", dunningLetterDistributionLookupResult.getCustomerNumber());
                primaryKeys.put("customerAddressTypeCode", "P");
                CustomerAddress address = (CustomerAddress)this.businessObjectService.findByPrimaryKey(CustomerAddress.class, primaryKeys);
                replacementList.put("agency.fullAddressInline", this.contractsGrantsBillingUtilityService.buildFullAddress(address));
                replacementList.put("agency.fullName", address.getCustomer().getCustomerName());
                replacementList.put("agency.contactName", address.getCustomer().getCustomerContactName());
                if (CollectionUtils.isNotEmpty(selectedInvoices)) {
                    reportStream = PdfFormFillerUtil.populateTemplate((File)templateFile, replacementList);
                    finalReportStream = this.generateListOfInvoicesPdfToPrint(selectedInvoices, reportStream);
                }
            }
            catch (DocumentException | IOException ex) {
                LOG.error((Object)("An exception occurred while retrieving invoice pdfs." + ex.getMessage()));
                finalReportStream = reportStream;
            }
        } else {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.fileUpload.save.noPdfFileSelected", new String[]{"test"});
        }
        return finalReportStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] createDunningLettersForAllResults(Collection<GenerateDunningLettersLookupResult> results) throws DocumentException, IOException {
        ByteArrayOutputStream zos = null;
        PdfCopyFields reportCopy = null;
        byte[] finalReport = null;
        try {
            zos = new ByteArrayOutputStream();
            reportCopy = new PdfCopyFields((OutputStream)zos);
            reportCopy.open();
            List dunningLetterTemplates = (List)this.getBusinessObjectService().findAll(DunningLetterTemplate.class);
            for (DunningLetterTemplate dunningLetterTemplate : dunningLetterTemplates) {
                for (GenerateDunningLettersLookupResult generateDunningLettersLookupResult : results) {
                    byte[] report = this.createDunningLetters(dunningLetterTemplate, generateDunningLettersLookupResult);
                    if (!org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)report)) continue;
                    reportCopy.addDocument(new PdfReader(report));
                }
            }
            reportCopy.close();
            finalReport = zos.toByteArray();
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
        return finalReport;
    }

    protected Map<String, String> getTemplateParameterList(List<ContractsGrantsInvoiceDocument> invoices) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(invoices)) {
            ContractsAndGrantsBillingAward award = invoices.get(0).getInvoiceGeneralDetail().getAward();
            HashMap primaryKeys = new HashMap();
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "award.proposalNumber", ObjectUtils.toString((Object)award.getProposalNumber()));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "currentDate", this.getDateTimeService().toDateTimeString(this.getDateTimeService().getCurrentDate()));
            if (CollectionUtils.isNotEmpty(invoices)) {
                for (int i = 0; i < invoices.size(); ++i) {
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "invoice[" + i + "].documentNumber", invoices.get(i).getDocumentNumber());
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "invoice[" + i + "].billingDate", this.getDateTimeService().toDateString((java.util.Date)invoices.get(i).getBillingDate()));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "invoice[" + i + "].totalAmount", this.contractsGrantsBillingUtilityService.formatForCurrency(invoices.get(i).getTotalDollarAmount()));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "invoice[" + i + "].customerName", invoices.get(i).getCustomerName());
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "invoice[" + i + "].customerNumber", invoices.get(i).getAccountsReceivableDocumentHeader().getCustomerNumber());
                }
            }
            if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award)) {
                this.contractsGrantsBillingUtilityService.putValueOrEmptyString(parameterMap, "award.awardProjectTitle", award.getAwardProjectTitle());
            }
        }
        return parameterMap;
    }

    @Override
    public boolean createZipOfPDFs(byte[] report, ByteArrayOutputStream baos) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(baos);
        byte[] buffer = new byte[1024];
        CRC32 crc = new CRC32();
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)report)) {
            int bytesRead;
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(report));
            crc.reset();
            while ((bytesRead = bis.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
            }
            bis.close();
            bis = new BufferedInputStream(new ByteArrayInputStream(report));
            ZipEntry entry = new ZipEntry("DunningLetters&Invoices-" + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".pdf");
            entry.setMethod(0);
            entry.setCompressedSize(report.length);
            entry.setSize(report.length);
            entry.setCrc(crc.getValue());
            zos.putNextEntry(entry);
            while ((bytesRead = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            bis.close();
        }
        zos.close();
        return true;
    }

    public byte[] generateListOfInvoicesPdfToPrint(Collection<ContractsGrantsInvoiceDocument> list, byte[] report) throws DocumentException, IOException {
        java.util.Date runDate = new java.util.Date();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generateCombinedPdfForInvoices(list, report, baos);
        return baos.toByteArray();
    }

    protected void generateCombinedPdfForInvoices(Collection<ContractsGrantsInvoiceDocument> list, byte[] report, OutputStream outputStream) throws DocumentException, IOException {
        PdfCopyFields copy = new PdfCopyFields(outputStream);
        copy.open();
        copy.addDocument(new PdfReader(report));
        for (ContractsGrantsInvoiceDocument invoice : list) {
            for (InvoiceAddressDetail invoiceAddressDetail : invoice.getInvoiceAddressDetails()) {
                Note note = this.noteService.getNoteByNoteId(Long.valueOf(invoiceAddressDetail.getNoteId()));
                if (!org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)note) || note.getAttachment().getAttachmentFileSize() <= 0L) continue;
                copy.addDocument(new PdfReader(note.getAttachment().getAttachmentContents()));
            }
        }
        copy.close();
    }

    @Override
    public boolean isValidOrganizationForTemplate(DunningLetterTemplate template, Person user) {
        ChartOrgHolder userChartOrg = this.getFinancialSystemUserService().getPrimaryOrganization(user, "KFS-AR");
        if (!StringUtils.isBlank((String)template.getBillByChartOfAccountCode()) && !StringUtils.isBlank((String)template.getBilledByOrganizationCode())) {
            return StringUtils.equals((String)template.getBillByChartOfAccountCode(), (String)userChartOrg.getChartOfAccountsCode()) && StringUtils.equals((String)template.getBilledByOrganizationCode(), (String)userChartOrg.getOrganizationCode());
        }
        return false;
    }

    @Override
    public Collection<GenerateDunningLettersLookupResult> getPopulatedGenerateDunningLettersLookupResults(Collection<ContractsGrantsInvoiceDocument> invoices) {
        ArrayList<GenerateDunningLettersLookupResult> populatedGenerateDunningLettersLookupResults = new ArrayList<GenerateDunningLettersLookupResult>();
        if (CollectionUtils.isEmpty(invoices)) {
            return populatedGenerateDunningLettersLookupResults;
        }
        Iterator<Map.Entry<Long, List<ContractsGrantsInvoiceDocument>>> iter = this.getContractsGrantsInvoiceDocumentService().getInvoicesByAward(invoices).entrySet().iterator();
        GenerateDunningLettersLookupResult generateDunningLettersLookupResult = null;
        while (iter.hasNext()) {
            ContractsGrantsInvoiceDocument document;
            ContractsAndGrantsBillingAward award;
            Map.Entry<Long, List<ContractsGrantsInvoiceDocument>> entry = iter.next();
            List<ContractsGrantsInvoiceDocument> list = entry.getValue();
            if (!CollectionUtils.isNotEmpty(list) || !org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)(award = (document = list.get(0)).getInvoiceGeneralDetail().getAward())) || award.isStopWorkIndicator()) continue;
            generateDunningLettersLookupResult = new GenerateDunningLettersLookupResult();
            generateDunningLettersLookupResult.setProposalNumber(award.getProposalNumber());
            generateDunningLettersLookupResult.setInvoiceDocumentNumber(document.getDocumentNumber());
            generateDunningLettersLookupResult.setAgencyNumber(award.getAgencyNumber());
            generateDunningLettersLookupResult.setCustomerNumber(document.getAccountsReceivableDocumentHeader().getCustomerNumber());
            generateDunningLettersLookupResult.setAwardTotal(award.getAwardTotalAmount());
            generateDunningLettersLookupResult.setCampaignID(award.getDunningCampaign());
            if (CollectionUtils.isNotEmpty(document.getAccountDetails())) {
                generateDunningLettersLookupResult.setAccountNumber(document.getAccountDetails().get(0).getAccountNumber());
            }
            generateDunningLettersLookupResult.setInvoices(list);
            populatedGenerateDunningLettersLookupResults.add(generateDunningLettersLookupResult);
        }
        return populatedGenerateDunningLettersLookupResults;
    }

    protected Map<Long, List<ContractsGrantsInvoiceDocument>> getInvoicesByAward(Collection<ContractsGrantsInvoiceDocument> invoices) {
        HashMap<Long, List<ContractsGrantsInvoiceDocument>> invoicesByAward = new HashMap<Long, List<ContractsGrantsInvoiceDocument>>();
        for (ContractsGrantsInvoiceDocument invoice : invoices) {
            Long proposalNumber = invoice.getInvoiceGeneralDetail().getProposalNumber();
            if (invoicesByAward.containsKey(proposalNumber)) {
                ((List)invoicesByAward.get(proposalNumber)).add(invoice);
                continue;
            }
            ArrayList<ContractsGrantsInvoiceDocument> invoicesByProposalNumber = new ArrayList<ContractsGrantsInvoiceDocument>();
            invoicesByProposalNumber.add(invoice);
            invoicesByAward.put(proposalNumber, invoicesByProposalNumber);
        }
        return invoicesByAward;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentDao getContractsGrantsInvoiceDocumentDao() {
        return this.contractsGrantsInvoiceDocumentDao;
    }

    public void setContractsGrantsInvoiceDocumentDao(ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao) {
        this.contractsGrantsInvoiceDocumentDao = contractsGrantsInvoiceDocumentDao;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }

    public ContractsGrantsBillingUtilityService getContractsGrantsBillingUtilityService() {
        return this.contractsGrantsBillingUtilityService;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

