/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.SuspensionCategoryBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class InvoiceAmountLessThanInvoiceMinimumSuspensionCategory
extends SuspensionCategoryBase {
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;

    @Override
    public boolean shouldSuspend(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        this.ensureTotalInvoiceAmountIsUpToDate(contractsGrantsInvoiceDocument);
        return this.shouldSuspend(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward().getMinInvoiceAmount(), contractsGrantsInvoiceDocument.getTotalInvoiceAmount());
    }

    protected void ensureTotalInvoiceAmountIsUpToDate(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!StringUtils.equalsIgnoreCase((String)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"MILE") && !StringUtils.equalsIgnoreCase((String)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"PDBS")) {
            this.contractsGrantsInvoiceDocumentService.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        }
    }

    protected boolean shouldSuspend(KualiDecimal minInvoiceAmount, KualiDecimal invoiceAmount) {
        if (minInvoiceAmount == null) {
            return false;
        }
        return invoiceAmount.isLessThan((AbstractKualiDecimal)minInvoiceAmount);
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }
}

