/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivablePredeterminedBillingSchedule;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PredeterminedBillingSchedule
extends PersistableBusinessObjectBase
implements AccountsReceivablePredeterminedBillingSchedule {
    protected static Logger LOG = Logger.getLogger(PredeterminedBillingSchedule.class);
    private static final String PREDETERMINED_BILLING_SCHEDULE_INQUIRY_TITLE_PROPERTY = "message.inquiry.predetermined.billing.schedule.title";
    private Long proposalNumber;
    private String predeterminedBillingScheduleInquiryTitle;
    private List<Bill> bills = new ArrayList<Bill>();
    private ContractsAndGrantsBillingAward award;

    public PredeterminedBillingSchedule() {
    }

    public PredeterminedBillingSchedule(ContractsAndGrantsBillingAward award) {
        this();
    }

    public Long getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(Long proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public KualiDecimal getTotalAmountScheduled() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (Bill bill : this.bills) {
            if (!ObjectUtils.isNotNull((Object)bill.getEstimatedAmount()) || !bill.isActive()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)bill.getEstimatedAmount());
        }
        return total;
    }

    public KualiDecimal getTotalAmountRemaining() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)this.award) && ObjectUtils.isNotNull((Object)this.award.getAwardTotalAmount())) {
            total = (KualiDecimal)this.award.getAwardTotalAmount().subtract((AbstractKualiDecimal)this.getTotalAmountScheduled());
        }
        return total;
    }

    public String getPredeterminedBillingScheduleInquiryTitle() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(PREDETERMINED_BILLING_SCHEDULE_INQUIRY_TITLE_PROPERTY);
    }

    public void setPredeterminedBillingScheduleInquiryTitle(String predeterminedBillingScheduleInquiryTitle) {
        this.predeterminedBillingScheduleInquiryTitle = predeterminedBillingScheduleInquiryTitle;
    }

    public List<Bill> getBills() {
        return this.bills;
    }

    public void setBills(List<Bill> bills) {
        this.bills = bills;
    }

    public ContractsAndGrantsBillingAward getAward() {
        this.award = ((ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class)).updateAwardIfNecessary(this.proposalNumber, this.award);
        return this.award;
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("proposalNumber", this.proposalNumber.toString());
        m.put("totalAmountScheduled", this.getTotalAmountScheduled().toString());
        m.put("totalAmountRemaining", this.getTotalAmountRemaining().toString());
        return m;
    }
}

