/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ARCollector;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.service.CustomerViewService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.kfs.sys.document.FinancialSystemMaintenanceDocument;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CustomerMaintenableImpl
extends FinancialSystemMaintainable {
    private static final Logger LOG = Logger.getLogger(CustomerMaintenableImpl.class);
    private static final String REQUIRES_APPROVAL_NODE = "RequiresApproval";
    private static final String BO_NOTES = "boNotes";
    private transient DateTimeService dateTimeService;
    private static volatile CustomerViewService customerViewService;

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        sections = CustomerMaintenableImpl.getCustomerViewService().getSections(sections);
        return sections;
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterPost(document, parameters);
        if (this.getMaintenanceAction().equalsIgnoreCase("New")) {
            Customer oldCustomer = (Customer)document.getOldMaintainableObject().getBusinessObject();
            Customer newCustomer = (Customer)document.getNewMaintainableObject().getBusinessObject();
            Date currentDate = this.getDateTimeService().getCurrentSqlDate();
            newCustomer.setCustomerRecordAddDate(currentDate);
            newCustomer.setCustomerLastActivityDate(currentDate);
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        if (this.getMaintenanceAction().equalsIgnoreCase("New")) {
            return;
        }
        if (documentHeader.getWorkflowDocument().isProcessed()) {
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            try {
                MaintenanceDocument document = (MaintenanceDocument)documentService.getByDocumentHeaderId(documentHeader.getDocumentNumber());
                Customer newCustomer = (Customer)document.getNewMaintainableObject().getBusinessObject();
                Customer oldCustomer = (Customer)document.getOldMaintainableObject().getBusinessObject();
                this.updateDates(oldCustomer, newCustomer);
            }
            catch (WorkflowException e) {
                LOG.error((Object)("caught exception while handling handleRouteStatusChange -> documentService.getByDocumentHeaderId(" + documentHeader.getDocumentNumber() + "). "), (Throwable)e);
            }
        }
    }

    private void updateDates(Customer oldCustomer, Customer newCustomer) {
        Date currentDate = this.getDateTimeService().getCurrentSqlDate();
        List<CustomerAddress> oldAddresses = oldCustomer.getCustomerAddresses();
        List<CustomerAddress> newAddresses = newCustomer.getCustomerAddresses();
        boolean addressChangeFlag = false;
        if (oldAddresses != null && newAddresses != null) {
            if (oldAddresses.size() != newAddresses.size()) {
                newCustomer.setCustomerAddressChangeDate(currentDate);
                newCustomer.setCustomerLastActivityDate(currentDate);
                addressChangeFlag = true;
            } else {
                for (int i = 0; i < oldAddresses.size(); ++i) {
                    CustomerAddress newAddress;
                    CustomerAddress oldAddress = oldAddresses.get(i);
                    if (oldAddress.compareTo(newAddress = newAddresses.get(i)) == 0) continue;
                    newCustomer.setCustomerAddressChangeDate(currentDate);
                    newCustomer.setCustomerLastActivityDate(currentDate);
                    addressChangeFlag = true;
                    break;
                }
            }
        }
        if (!addressChangeFlag && !((Object)((Object)oldCustomer)).equals((Object)newCustomer)) {
            newCustomer.setCustomerLastActivityDate(currentDate);
        }
    }

    public PersistableBusinessObject initNewCollectionLine(String collectionName) {
        PersistableBusinessObject businessObject = super.initNewCollectionLine(collectionName);
        Customer customer = (Customer)this.businessObject;
        if (collectionName.equalsIgnoreCase("customerAddresses")) {
            CustomerAddress customerAddress = (CustomerAddress)businessObject;
            customerAddress.setCustomerAddressName(customer.getCustomerName());
            if ("New".equalsIgnoreCase(this.getMaintenanceAction())) {
                boolean hasPrimaryAddress = false;
                for (CustomerAddress tempAddress : customer.getCustomerAddresses()) {
                    if (!"P".equalsIgnoreCase(tempAddress.getCustomerAddressTypeCode())) continue;
                    hasPrimaryAddress = true;
                    break;
                }
                if (hasPrimaryAddress) {
                    customerAddress.setCustomerAddressTypeCode("A");
                } else {
                    customerAddress.setCustomerAddressTypeCode("P");
                }
            }
            if ("Edit".equalsIgnoreCase(this.getMaintenanceAction()) || "Copy".equalsIgnoreCase(this.getMaintenanceAction())) {
                customerAddress.setCustomerAddressTypeCode("A");
            }
        }
        return businessObject;
    }

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (!REQUIRES_APPROVAL_NODE.equals(nodeName)) {
            throw new UnsupportedOperationException("answerSplitNodeQuestion('" + nodeName + "') was called, but no handler is present for that nodeName.");
        }
        FinancialSystemMaintenanceDocument maintDoc = this.getParentMaintDoc();
        if (maintDoc.isEdit()) {
            return !this.oldAndNewAreEqual(maintDoc);
        }
        return maintDoc.isNew() && this.createdByWebApp(maintDoc);
    }

    private boolean oldAndNewAreEqual(FinancialSystemMaintenanceDocument maintDoc) {
        Customer oldBo = (Customer)maintDoc.getOldMaintainableObject().getBusinessObject();
        Customer newBo = (Customer)maintDoc.getNewMaintainableObject().getBusinessObject();
        return this.oldAndNewObjectIsEqual("Customer", (Object)oldBo, (Object)newBo);
    }

    private boolean oldAndNewObjectIsEqual(String objectName, Object oldObject, Object newObject) {
        Map newProps;
        Map oldProps;
        if (oldObject == null && newObject == null) {
            return true;
        }
        if (oldObject == null || newObject == null) {
            return false;
        }
        if (!oldObject.getClass().getName().equals(newObject.getClass().getName())) {
            return false;
        }
        try {
            oldProps = PropertyUtils.describe((Object)oldObject);
            newProps = PropertyUtils.describe((Object)newObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception raised while trying to get a list of properties on OldCustomer.", e);
        }
        for (String propName : oldProps.keySet()) {
            Object newValue;
            Object oldValue;
            if (this.oldAndNewPropertyIsEqual(propName, oldValue = oldProps.get(propName), newValue = newProps.get(propName))) continue;
            return false;
        }
        return true;
    }

    private boolean oldAndNewPropertyIsEqual(String propName, Object oldValue, Object newValue) {
        if (BO_NOTES.equalsIgnoreCase(propName)) {
            return true;
        }
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null || newValue == null) {
            return false;
        }
        if (!oldValue.getClass().getName().equals(newValue.getClass().getName())) {
            return false;
        }
        if (Collection.class.isAssignableFrom(oldValue.getClass())) {
            Object[] newCollection;
            Object[] oldCollection = ((Collection)oldValue).toArray();
            if (oldCollection.length != (newCollection = ((Collection)newValue).toArray()).length) {
                return false;
            }
            for (int i = 0; i < oldCollection.length; ++i) {
                if (this.oldAndNewObjectIsEqual("COLLECTION: " + propName, oldCollection[i], newCollection[i])) continue;
                return false;
            }
            return true;
        }
        boolean result = oldValue.toString().equals(newValue.toString());
        return result;
    }

    private FinancialSystemMaintenanceDocument getParentMaintDoc() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        FinancialSystemMaintenanceDocument maintDoc = null;
        try {
            maintDoc = (FinancialSystemMaintenanceDocument)documentService.getByDocumentHeaderId(this.getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        return maintDoc;
    }

    private boolean createdByWebApp(FinancialSystemMaintenanceDocument maintDoc) {
        String initiatorPrincipalId = maintDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Principal initiatorPrincipal = KimApiServiceLocator.getIdentityService().getPrincipal(initiatorPrincipalId);
        return initiatorPrincipal != null && !"kfs".equals(initiatorPrincipal.getPrincipalName());
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void addNewLineToCollection(String collectionName) {
        this.refreshCustomer(false);
        super.addNewLineToCollection(collectionName);
    }

    private void refreshCustomer(boolean refreshFromLookup) {
        Customer customer = this.getCustomer();
        customer.refreshNonUpdateableReferences();
    }

    private void refreshWithSecondaryKey(ARCollector arCollector) {
        Person collector = arCollector.getCollector();
        if (ObjectUtils.isNotNull((Object)collector)) {
            Person person;
            String secondaryKey = collector.getPrincipalName();
            if (StringUtils.isNotBlank((String)secondaryKey)) {
                Person dir = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(secondaryKey);
                arCollector.setPrincipalId(dir == null ? null : dir.getPrincipalId());
            }
            if (StringUtils.isNotBlank((String)arCollector.getPrincipalId()) && (person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(arCollector.getPrincipalId())) != null) {
                ((PersistableBusinessObject)arCollector).refreshNonUpdateableReferences();
            }
        }
    }

    public Customer getCustomer() {
        return (Customer)this.getBusinessObject();
    }

    private static void refreshNonUpdateableReferences(Collection<? extends PersistableBusinessObject> collection) {
        for (PersistableBusinessObject persistableBusinessObject : collection) {
            persistableBusinessObject.refreshNonUpdateableReferences();
        }
    }

    public void processAfterRetrieve() {
        this.refreshCustomer(false);
        super.processAfterRetrieve();
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterEdit(document, parameters);
        this.defaultInvoiceTemplate(this.getCustomer(), document);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterEdit(document, parameters);
        this.defaultInvoiceTemplate(this.getCustomer(), document);
    }

    private void defaultInvoiceTemplate(Customer customer, MaintenanceDocument document) {
        if (ObjectUtils.isNotNull((Object)((Object)customer))) {
            CustomerAddress newCustomerAddress = (CustomerAddress)document.getNewMaintainableObject().getNewCollectionLine("customerAddresses");
            newCustomerAddress.setCustomerInvoiceTemplateCode(customer.getCustomerInvoiceTemplateCode());
        }
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        this.defaultInvoiceTemplate(this.getCustomer(), document);
    }

    public static CustomerViewService getCustomerViewService() {
        if (customerViewService == null) {
            customerViewService = (CustomerViewService)SpringContext.getBean(CustomerViewService.class);
        }
        return customerViewService;
    }
}

