/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.lang.constant.Constable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingFrequency;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ContractsGrantsBillingAwardVerificationServiceImpl
implements ContractsGrantsBillingAwardVerificationService {
    protected AccountingPeriodService accountingPeriodService;
    protected BusinessObjectService businessObjectService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected CustomerService customerService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected VerifyBillingFrequencyService verifyBillingFrequencyService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;

    @Override
    public boolean isBillingFrequencySetCorrectly(ContractsAndGrantsBillingAward award) {
        return !StringUtils.isBlank((String)award.getBillingFrequencyCode()) && (!award.getBillingFrequencyCode().equalsIgnoreCase("PDBS") && !award.getBillingFrequencyCode().equalsIgnoreCase("MILE") || award.getActiveAwardAccounts().size() == 1);
    }

    @Override
    public boolean isValueOfBillingFrequencyValid(ContractsAndGrantsBillingAward award) {
        if (!StringUtils.isBlank((String)award.getBillingFrequencyCode())) {
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("frequency", award.getBillingFrequencyCode());
            criteria.put("active", true);
            List matchingBillingFrequencies = this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingFrequency.class).getExternalizableBusinessObjectsList(ContractsAndGrantsBillingFrequency.class, criteria);
            if (matchingBillingFrequencies != null && matchingBillingFrequencies.size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAwardFinalInvoiceAlreadyBuilt(ContractsAndGrantsBillingAward award) {
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            if (!awardAccount.isFinalBilledIndicator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvoiceInProgress(ContractsAndGrantsBillingAward award) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.getFinancialSystemDocumentService().getPendingDocumentStatuses());
        return this.getBusinessObjectService().countMatching(ContractsGrantsInvoiceDocument.class, fieldValues) > 0;
    }

    @Override
    public boolean hasMilestonesToInvoice(ContractsAndGrantsBillingAward award) {
        boolean hasMilestonesToInvoice = true;
        if (award.getBillingFrequencyCode().equalsIgnoreCase("MILE")) {
            List milestones = new ArrayList();
            ArrayList<Milestone> validMilestones = new ArrayList<Milestone>();
            HashMap<String, Constable> map = new HashMap<String, Constable>();
            map.put("proposalNumber", award.getProposalNumber());
            map.put("active", Boolean.valueOf(true));
            milestones = (List)this.businessObjectService.findMatching(Milestone.class, map);
            Timestamp ts = new Timestamp(new java.util.Date().getTime());
            Date today = new Date(ts.getTime());
            AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
            BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
            Date invoiceDate = billingPeriod.getEndDate();
            for (Milestone awdMilestone : milestones) {
                if (awdMilestone.getMilestoneActualCompletionDate() == null || invoiceDate.before(awdMilestone.getMilestoneActualCompletionDate()) || awdMilestone.isBilled() || !awdMilestone.getMilestoneAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
                validMilestones.add(awdMilestone);
            }
            if (CollectionUtils.isEmpty(validMilestones)) {
                hasMilestonesToInvoice = false;
            }
        }
        return hasMilestonesToInvoice;
    }

    @Override
    public boolean hasBillsToInvoice(ContractsAndGrantsBillingAward award) {
        boolean hasBillsToInvoice = true;
        if (award.getBillingFrequencyCode().equalsIgnoreCase("PDBS")) {
            List bills = new ArrayList();
            ArrayList<Bill> validBills = new ArrayList<Bill>();
            HashMap<String, Constable> map = new HashMap<String, Constable>();
            map.put("proposalNumber", award.getProposalNumber());
            map.put("active", Boolean.valueOf(true));
            bills = (List)this.businessObjectService.findMatching(Bill.class, map);
            Timestamp ts = new Timestamp(new java.util.Date().getTime());
            Date today = new Date(ts.getTime());
            AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
            BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
            Date invoiceDate = billingPeriod.getEndDate();
            for (Bill awdBill : bills) {
                if (awdBill.getBillDate() == null || invoiceDate.before(awdBill.getBillDate()) || awdBill.isBilled() || !awdBill.getEstimatedAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
                validBills.add(awdBill);
            }
            if (CollectionUtils.isEmpty(validBills)) {
                hasBillsToInvoice = false;
            }
        }
        return hasBillsToInvoice;
    }

    @Override
    public boolean owningAgencyHasCustomerRecord(ContractsAndGrantsBillingAward award) {
        boolean isValid = true;
        if (ObjectUtils.isNotNull((Object)award.getAgency().getCustomerNumber())) {
            Customer customer = this.customerService.getByPrimaryKey(award.getAgency().getCustomerNumber());
            return !ObjectUtils.isNull((Object)((Object)customer));
        }
        return false;
    }

    @Override
    public boolean isChartAndOrgSetupForInvoicing(ContractsAndGrantsBillingAward award) {
        String coaCode = award.getPrimaryAwardOrganization().getChartOfAccountsCode();
        String orgCode = award.getPrimaryAwardOrganization().getOrganizationCode();
        Object procCoaCode = null;
        Object procOrgCode = null;
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentYear);
        sysCriteria.put("universityFiscalYear", currentYear);
        criteria.put("chartOfAccountsCode", coaCode);
        criteria.put("organizationCode", orgCode);
        List<String> procCodes = this.getContractsGrantsInvoiceDocumentService().getProcessingFromBillingCodes(coaCode, orgCode);
        if (!CollectionUtils.isEmpty(procCodes) && procCodes.size() > 1) {
            sysCriteria.put("processingChartOfAccountCode", procCodes.get(0));
            sysCriteria.put("processingOrganizationCode", procCodes.get(1));
            OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
            SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, sysCriteria);
            if (ObjectUtils.isNotNull((Object)((Object)organizationAccountingDefault)) && ObjectUtils.isNotNull((Object)((Object)systemInformation))) {
                return true;
            }
        }
        return false;
    }

    public AccountingPeriodService getAccountingPeriodService() {
        return this.accountingPeriodService;
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public VerifyBillingFrequencyService getVerifyBillingFrequencyService() {
        return this.verifyBillingFrequencyService;
    }

    public void setVerifyBillingFrequencyService(VerifyBillingFrequencyService verifyBillingFrequencyService) {
        this.verifyBillingFrequencyService = verifyBillingFrequencyService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

