/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceDetailUnitPriceValidation
extends GenericValidation {
    private CustomerInvoiceDetail customerInvoiceDetail;
    private CustomerInvoiceDocument customerInvoiceDocument;

    public boolean validate(AttributedDocumentEvent event) {
        BigDecimal unitPrice = this.customerInvoiceDetail.getInvoiceItemUnitPrice();
        if (ObjectUtils.isNull((Object)unitPrice) || BigDecimal.ZERO.equals(unitPrice)) {
            GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice", new String[0]);
            return false;
        }
        if (this.customerInvoiceDocument.isInvoiceReversal()) {
            if (this.customerInvoiceDetail.isDiscountLine() && unitPrice.compareTo(BigDecimal.ZERO) == -1) {
                GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice", new String[0]);
                return false;
            }
            if (!this.customerInvoiceDetail.isDiscountLine() && unitPrice.compareTo(BigDecimal.ZERO) == 1) {
                GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice", new String[0]);
                return false;
            }
        } else if (!this.customerInvoiceDetail.isDiscountLine() && unitPrice.compareTo(BigDecimal.ZERO) == -1) {
            GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailUnitPrice", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceDetail getCustomerInvoiceDetail() {
        return this.customerInvoiceDetail;
    }

    public void setCustomerInvoiceDetail(CustomerInvoiceDetail customerInvoiceDetail) {
        this.customerInvoiceDetail = customerInvoiceDetail;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }
}

