/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class FinalBilledIndicatorValidation {
    private static final Logger LOG = Logger.getLogger(FinalBilledIndicatorValidation.class);

    public static boolean validateDocument(Document document) {
        boolean valid = true;
        List<FinalBilledIndicatorEntry> invoiceEntries = ((FinalBilledIndicatorDocument)document).getInvoiceEntries();
        if (CollectionUtils.isEmpty(invoiceEntries)) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.no.invoice", new String[0]);
            valid = false;
        } else {
            for (FinalBilledIndicatorEntry entry : invoiceEntries) {
                valid &= FinalBilledIndicatorValidation.validateEntry(entry);
            }
        }
        return valid;
    }

    public static boolean validateEntry(FinalBilledIndicatorEntry entry) {
        if (ObjectUtils.isNull((Object)((Object)entry)) || ObjectUtils.isNull((Object)entry.getInvoiceDocumentNumber())) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.no.invoice", new String[0]);
            return false;
        }
        return FinalBilledIndicatorValidation.validContractsGrantsInvoiceValidation(entry);
    }

    public static boolean validContractsGrantsInvoiceValidation(FinalBilledIndicatorEntry entry) {
        String docNumber = entry.getInvoiceDocumentNumber();
        try {
            if (((DocumentService)SpringContext.getBean(DocumentService.class)).documentExists(docNumber)) {
                Document testDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docNumber);
                if (!testDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("CINV")) {
                    GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invalid.invoice", new String[0]);
                    return false;
                }
                return FinalBilledIndicatorValidation.entryValidations((ContractsGrantsInvoiceDocument)testDocument);
            }
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invalid.invoice", new String[0]);
            return false;
        }
        catch (WorkflowException ex) {
            LOG.error((Object)"problem during FinalBilledIndicatorValidation.validContractsGrantsInvoiceValidation()", (Throwable)ex);
            throw new RuntimeException("problem during FinalBilledIndicatorValidation.validContractsGrantsInvoiceValidation()", ex);
        }
    }

    public static boolean entryValidations(ContractsGrantsInvoiceDocument document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!workflowDocument.isFinal() && !workflowDocument.isProcessed()) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invoice.not.final", new String[0]);
            return false;
        }
        if (!document.getInvoiceGeneralDetail().isFinalBillIndicator()) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invoice.not.marked.final.bill", new String[0]);
            return false;
        }
        return true;
    }
}

