/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import au.com.bytecode.opencsv.CSVWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfCopyFields;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.IndirectCostRecoveryRateDetail;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.sys.PdfFormFillerUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class ContractsGrantsInvoiceReportServiceImpl
implements ContractsGrantsInvoiceReportService {
    private static final Logger LOG = Logger.getLogger(ContractsGrantsInvoiceReportServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected DataDictionaryService dataDictionaryService;
    protected PersonService personService;
    protected BusinessObjectService businessObjectService;
    protected ParameterService parameterService;
    protected ConfigurationService configService;
    protected KualiModuleService kualiModuleService;
    protected DocumentService documentService;
    protected NoteService noteService;
    protected ReportInfo reportInfo;
    protected ReportGenerationService reportGenerationService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected OptionsService optionsService;

    @Override
    public byte[] generateLOCReviewAsPdf(ContractsGrantsLetterOfCreditReviewDocument document) {
        Date runDate = new Date(new java.util.Date().getTime());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generateLOCReviewInPdf(baos, document);
        return baos.toByteArray();
    }

    protected void generateLOCReviewInPdf(OutputStream os, ContractsGrantsLetterOfCreditReviewDocument locDocument) {
        try {
            Document document = new Document(new Rectangle(1350.0f, 595.0f));
            PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            Paragraph header = new Paragraph();
            Paragraph text = new Paragraph();
            Paragraph title = new Paragraph();
            header.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.title"), ArConstants.PdfReportFonts.LOC_REVIEW_TITLE_FONT));
            if (StringUtils.isNotEmpty((String)locDocument.getLetterOfCreditFundGroupCode())) {
                header.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.fund.group.code") + locDocument.getLetterOfCreditFundGroupCode(), ArConstants.PdfReportFonts.LOC_REVIEW_TITLE_FONT));
            }
            if (StringUtils.isNotEmpty((String)locDocument.getLetterOfCreditFundCode())) {
                header.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.fund.code") + locDocument.getLetterOfCreditFundCode(), ArConstants.PdfReportFonts.LOC_REVIEW_TITLE_FONT));
            }
            header.add((Object)new Paragraph(" "));
            header.setAlignment(1);
            title.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.document.number") + locDocument.getDocumentNumber(), ArConstants.PdfReportFonts.LOC_REVIEW_HEADER_FONT));
            Person person = this.getPersonService().getPerson(locDocument.getFinancialSystemDocumentHeader().getInitiatorPrincipalId());
            title.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.application.document.status") + locDocument.getFinancialSystemDocumentHeader().getApplicationDocumentStatus(), ArConstants.PdfReportFonts.LOC_REVIEW_HEADER_FONT));
            title.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.initiator.principal.name") + person.getName(), ArConstants.PdfReportFonts.LOC_REVIEW_HEADER_FONT));
            title.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.header.create.date") + this.getDateTimeService().toDateString((java.util.Date)locDocument.getFinancialSystemDocumentHeader().getWorkflowCreateDate()), ArConstants.PdfReportFonts.LOC_REVIEW_HEADER_FONT));
            title.add((Object)new Paragraph(" "));
            title.setAlignment(2);
            text.add((Object)new Paragraph(this.configService.getPropertyValueAsString("locreview.pdf.subheader.awards"), ArConstants.PdfReportFonts.LOC_REVIEW_SMALL_BOLD));
            text.add((Object)new Paragraph(" "));
            document.add((Element)header);
            document.add((Element)title);
            document.add((Element)text);
            PdfPTable table = new PdfPTable(11);
            table.setTotalWidth(1300.0f);
            table.setLockedWidth(true);
            float[] widths = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            table.setWidths(widths);
            table.setHorizontalAlignment(0);
            this.addAwardHeaders(table);
            if (CollectionUtils.isNotEmpty(locDocument.getHeaderReviewDetails()) && CollectionUtils.isNotEmpty(locDocument.getAccountReviewDetails())) {
                for (ContractsGrantsLetterOfCreditReviewDetail item : locDocument.getHeaderReviewDetails()) {
                    table.addCell(Long.toString(item.getProposalNumber()));
                    table.addCell(item.getAwardDocumentNumber());
                    table.addCell(item.getAgencyNumber());
                    table.addCell(item.getCustomerNumber());
                    table.addCell(this.getDateTimeService().toDateString((java.util.Date)item.getAwardBeginningDate()));
                    table.addCell(this.getDateTimeService().toDateString((java.util.Date)item.getAwardEndingDate()));
                    table.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(item.getAwardBudgetAmount()));
                    table.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(item.getLetterOfCreditAmount()));
                    table.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(item.getClaimOnCashBalance()));
                    table.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(item.getAmountToDraw()));
                    table.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(item.getAmountAvailableToDraw()));
                    PdfPCell cell = new PdfPCell();
                    cell.setPadding(20.0f);
                    cell.setColspan(11);
                    PdfPTable newTable = new PdfPTable(8);
                    newTable.setTotalWidth(1000.0f);
                    newTable.setLockedWidth(true);
                    float[] newWidths = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
                    newTable.setWidths(newWidths);
                    newTable.setHorizontalAlignment(0);
                    this.addAccountsHeaders(newTable);
                    for (ContractsGrantsLetterOfCreditReviewDetail newItem : locDocument.getAccountReviewDetails()) {
                        if (!item.getProposalNumber().equals(newItem.getProposalNumber())) continue;
                        newTable.addCell(newItem.getAccountDescription());
                        newTable.addCell(newItem.getChartOfAccountsCode());
                        newTable.addCell(newItem.getAccountNumber());
                        String accountExpirationDate = "";
                        if (!org.kuali.kfs.krad.util.ObjectUtils.isNull((Object)newItem.getAccountExpirationDate())) {
                            accountExpirationDate = this.getDateTimeService().toDateString((java.util.Date)newItem.getAccountExpirationDate());
                        }
                        newTable.addCell(accountExpirationDate);
                        newTable.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getAwardBudgetAmount()));
                        newTable.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getClaimOnCashBalance()));
                        newTable.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getAmountToDraw()));
                        newTable.addCell(this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getFundsNotDrawn()));
                    }
                    cell.addElement((Element)newTable);
                    table.addCell(cell);
                }
                document.add((Element)table);
            }
            document.close();
        }
        catch (DocumentException e) {
            LOG.error((Object)"problem during ContractsGrantsInvoiceReportServiceImpl.generateInvoiceInPdf()", (Throwable)e);
        }
    }

    protected void addAccountsHeaders(PdfPTable table) {
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountDescription"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "chartOfAccountsCode"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountNumber"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountExpirationDate"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardBudgetAmount"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "claimOnCashBalance"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "amountToDraw"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "fundsNotDrawn"));
    }

    protected void addAwardHeaders(PdfPTable table) {
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "proposalNumber"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardDocumentNumber"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "agencyNumber"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "customerNumber"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardBeginningDate"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardEndingDate"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardBudgetAmount"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "letterOfCreditAmount"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "claimOnCashBalance"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "amountToDraw"));
        table.addCell(this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "fundsNotDrawn"));
    }

    @Override
    public File generateFederalFinancialForm(ContractsAndGrantsBillingAward award, String period, String year, String formType, ContractsAndGrantsBillingAgency agency) {
        HashMap<String, String> replacementList = new HashMap<String, String>();
        Date runDate = new Date(new java.util.Date().getTime());
        String reportFileName = this.getReportInfo().getReportFileName();
        String reportDirectory = this.getReportInfo().getReportsDirectory();
        try {
            if (formType.equals("425") && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award)) {
                String fullReportFileName = this.reportGenerationService.buildFullFileName((java.util.Date)runDate, reportDirectory, reportFileName, "FF425") + ".pdf";
                File file = new File(fullReportFileName);
                FileOutputStream fos = new FileOutputStream(file);
                this.stampPdfFormValues425(award, period, year, fos, replacementList);
                return file;
            }
            if (formType.equals("425A") && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)agency)) {
                String fullReportFileName = this.reportGenerationService.buildFullFileName((java.util.Date)runDate, reportDirectory, reportFileName, "FF425A") + ".pdf";
                File file = new File(fullReportFileName);
                FileOutputStream fos = new FileOutputStream(file);
                this.stampPdfFormValues425A(agency, period, year, fos, replacementList);
                return file;
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Cannot find pdf to stamp for federal financial form", ex);
        }
        return null;
    }

    protected KualiDecimal getCashReceipts(ContractsAndGrantsBillingAward award) {
        List list;
        KualiDecimal cashReceipt = KualiDecimal.ZERO;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award) && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award.getProposalNumber())) {
            fieldValues.put("proposalNumber", award.getProposalNumber().toString());
        }
        if (!CollectionUtils.isEmpty((Collection)(list = (List)this.contractsGrantsInvoiceDocumentService.retrieveAllCGInvoicesByCriteria(fieldValues)))) {
            for (ContractsGrantsInvoiceDocument invoice : list) {
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("financialDocumentReferenceInvoiceNumber", invoice.getDocumentNumber());
                List ipas = (List)this.businessObjectService.findMatching(InvoicePaidApplied.class, primaryKeys);
                if (!org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)ipas)) continue;
                for (InvoicePaidApplied ipa : ipas) {
                    cashReceipt = (KualiDecimal)cashReceipt.add((AbstractKualiDecimal)ipa.getInvoiceItemAppliedAmount());
                }
            }
        }
        return cashReceipt;
    }

    protected void populateListByAward(ContractsAndGrantsBillingAward award, String reportingPeriod, String year, Map<String, String> replacementList) {
        String accountingBasis;
        KualiDecimal cashDisbursement = KualiDecimal.ZERO;
        SystemOptions systemOption = this.optionsService.getCurrentYearOptions();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            int index = 0;
            KualiDecimal baseSum = KualiDecimal.ZERO;
            KualiDecimal amountSum = KualiDecimal.ZERO;
            cashDisbursement = (KualiDecimal)cashDisbursement.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, systemOption.getActualFinancialBalanceTypeCd(), award.getAwardBeginningDate()));
            if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)awardAccount.getAccount().getFinancialIcrSeriesIdentifier()) && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)awardAccount.getAccount().getAcctIndirectCostRcvyTypeCd())) {
                KualiDecimal rate;
                this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Type " + ++index, awardAccount.getAccount().getAcctIndirectCostRcvyTypeCd());
                this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Rate " + index, awardAccount.getAccount().getFinancialIcrSeriesIdentifier());
                if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)awardAccount.getAccount().getAccountEffectiveDate())) {
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Period From " + index, this.getDateTimeService().toDateString((java.util.Date)awardAccount.getAccount().getAccountEffectiveDate()));
                }
                if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)awardAccount.getAccount().getAccountExpirationDate())) {
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Period To " + index, this.getDateTimeService().toDateString((java.util.Date)awardAccount.getAccount().getAccountExpirationDate()));
                }
                this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Base " + index, this.contractsGrantsBillingUtilityService.formatForCurrency(award.getAwardTotalAmount()));
                HashMap<String, Object> key = new HashMap<String, Object>();
                key.put("universityFiscalYear", year);
                key.put("financialIcrSeriesIdentifier", awardAccount.getAccount().getFinancialIcrSeriesIdentifier());
                key.put("active", true);
                key.put("transactionDebitIndicator", "D");
                List icrDetail = (List)this.businessObjectService.findMatchingOrderBy(IndirectCostRecoveryRateDetail.class, key, "awardIndrCostRcvyEntryNbr", false);
                if (CollectionUtils.isNotEmpty((Collection)icrDetail) && org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)(rate = new KualiDecimal(((IndirectCostRecoveryRateDetail)icrDetail.get(0)).getAwardIndrCostRcvyRatePct())))) {
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Amount " + index, this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)award.getAwardTotalAmount().multiply((AbstractKualiDecimal)rate)));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Federal " + index, this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)award.getAwardTotalAmount().multiply((AbstractKualiDecimal)rate)));
                    amountSum = (KualiDecimal)amountSum.add(award.getAwardTotalAmount().multiply((AbstractKualiDecimal)rate));
                }
                baseSum = (KualiDecimal)baseSum.add((AbstractKualiDecimal)award.getAwardTotalAmount());
            }
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Base Sum", this.contractsGrantsBillingUtilityService.formatForCurrency(baseSum));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Amount Sum", this.contractsGrantsBillingUtilityService.formatForCurrency(amountSum));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Indirect Expense Federal Sum", this.contractsGrantsBillingUtilityService.formatForCurrency(amountSum));
        }
        SystemInformation sysInfo = this.retrieveSystemInformationForAward(award, year);
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)((Object)sysInfo))) {
            String address = this.concatenateAddressFromSystemInformation(sysInfo);
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Recipient Organization", address);
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "EIN", sysInfo.getUniversityFederalEmployerIdentificationNumber());
        }
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Agency", award.getAgency().getFullName());
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Grant Number", award.getAwardDocumentNumber());
        if (CollectionUtils.isNotEmpty((Collection)award.getActiveAwardAccounts())) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Recipient Account Number", ((ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(0)).getAccountNumber());
        }
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award.getAwardBeginningDate())) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Grant Period From", this.getDateTimeService().toDateString((java.util.Date)award.getAwardBeginningDate()));
        }
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)award.getAwardClosingDate())) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Grant Period To", this.getDateTimeService().toDateString((java.util.Date)award.getAwardClosingDate()));
        }
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash Receipts", this.contractsGrantsBillingUtilityService.formatForCurrency(this.getCashReceipts(award)));
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Total Federal Funds Authorized", this.contractsGrantsBillingUtilityService.formatForCurrency(award.getAwardTotalAmount()));
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Reporting Period End Date", this.getReportingPeriodEndDate(reportingPeriod, year));
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)cashDisbursement)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash Disbursements", this.contractsGrantsBillingUtilityService.formatForCurrency(cashDisbursement));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash on Hand", this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)this.getCashReceipts(award).subtract((AbstractKualiDecimal)cashDisbursement)));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Share of Expenditures", this.contractsGrantsBillingUtilityService.formatForCurrency(cashDisbursement));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Total Federal Share", this.contractsGrantsBillingUtilityService.formatForCurrency(cashDisbursement));
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Unobligated Balance of Federal Funds", this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)award.getAwardTotalAmount().subtract((AbstractKualiDecimal)cashDisbursement)));
        }
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Share of Unliquidated Obligations", this.contractsGrantsBillingUtilityService.formatForCurrency(KualiDecimal.ZERO));
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Total Federal Income Earned", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Income Expended in Accordance to Deduction Alternative", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Income Expended in Accordance to Addition Alternative", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Unexpended Program Income", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Name", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Telephone", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Email Address", "");
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Date Report Submitted", this.getDateTimeService().toDateString(this.getDateTimeService().getCurrentDate()));
        if ("q1".equals(reportingPeriod) || "q2".equals(reportingPeriod) || "q3".equals(reportingPeriod) || "q4".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Quaterly", "Yes");
        }
        if ("Sa".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Semi Annual", "Yes");
        }
        if ("An".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Annual", "Yes");
        }
        if ("F".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Final", "Yes");
        }
        if ("1".equals(accountingBasis = this.parameterService.getParameterValueAsString("KFS-AR", "All", "DEFAULT_BASIS_OF_ACCOUNTING_FOR_BILLING"))) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash", "Yes");
        }
        if ("2".equals(accountingBasis)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Accrual", "Yes");
        }
    }

    protected String concatenateAddressFromSystemInformation(SystemInformation sysInfo) {
        String address = sysInfo.getOrganizationRemitToAddressName();
        if (!StringUtils.isBlank((String)sysInfo.getOrganizationRemitToLine1StreetAddress())) {
            address = address + ", " + sysInfo.getOrganizationRemitToLine1StreetAddress();
        }
        if (!StringUtils.isBlank((String)sysInfo.getOrganizationRemitToLine2StreetAddress())) {
            address = address + ", " + sysInfo.getOrganizationRemitToLine2StreetAddress();
        }
        if (!StringUtils.isBlank((String)sysInfo.getOrganizationRemitToCityName())) {
            address = address + ", " + sysInfo.getOrganizationRemitToCityName();
        }
        if (!StringUtils.isBlank((String)sysInfo.getOrganizationRemitToStateCode())) {
            address = address + " " + sysInfo.getOrganizationRemitToStateCode();
        }
        if (!StringUtils.isBlank((String)sysInfo.getOrganizationRemitToZipCode())) {
            address = address + "-" + sysInfo.getOrganizationRemitToZipCode();
        }
        return address;
    }

    protected SystemInformation retrieveSystemInformationForAward(ContractsAndGrantsBillingAward award, String year) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("universityFiscalYear", year);
        primaryKeys.put("processingChartOfAccountCode", award.getPrimaryAwardOrganization().getChartOfAccountsCode());
        primaryKeys.put("processingOrganizationCode", award.getPrimaryAwardOrganization().getOrganizationCode());
        SystemInformation sysInfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, primaryKeys);
        return sysInfo;
    }

    protected List<KualiDecimal> populateListByAgency(List<ContractsAndGrantsBillingAward> awards, String reportingPeriod, String year, ContractsAndGrantsBillingAgency agency) {
        String accountingBasis;
        SystemInformation sysInfo;
        HashMap<String, String> replacementList = new HashMap<String, String>();
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Reporting Period End Date", this.getReportingPeriodEndDate(reportingPeriod, year));
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Agency", agency.getFullName());
        SystemOptions systemOption = this.optionsService.getCurrentYearOptions();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("universityFiscalYear", year);
        if (CollectionUtils.isNotEmpty(awards)) {
            primaryKeys.put("processingChartOfAccountCode", awards.get(0).getPrimaryAwardOrganization().getChartOfAccountsCode());
            primaryKeys.put("processingOrganizationCode", awards.get(0).getPrimaryAwardOrganization().getOrganizationCode());
        }
        if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)((Object)(sysInfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, primaryKeys))))) {
            String address = this.concatenateAddressFromSystemInformation(sysInfo);
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Recipient Organization", address);
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "EIN", sysInfo.getUniversityFederalEmployerIdentificationNumber());
        }
        if ("q1".equals(reportingPeriod) || "q2".equals(reportingPeriod) || "q3".equals(reportingPeriod) || "q4".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Quaterly", "Yes");
        }
        if ("Sa".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Semi Annual", "Yes");
        }
        if ("An".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Annual", "Yes");
        }
        if ("F".equals(reportingPeriod)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Final", "Yes");
        }
        if ("1".equals(accountingBasis = this.parameterService.getParameterValueAsString("KFS-AR", "All", "DEFAULT_BASIS_OF_ACCOUNTING_FOR_BILLING"))) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash", "Yes");
        }
        if ("2".equals(accountingBasis)) {
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Accrual", "Yes");
        }
        this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Date Report Submitted", this.getDateTimeService().toDateString((java.util.Date)new Date(new java.util.Date().getTime())));
        KualiDecimal totalCashControl = KualiDecimal.ZERO;
        KualiDecimal totalCashDisbursement = KualiDecimal.ZERO;
        for (int i = 0; i < 30; ++i) {
            if (i >= awards.size()) continue;
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Grant Number " + (i + 1), awards.get(i).getAwardDocumentNumber());
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Recipient Account Number " + (i + 1), ((ContractsAndGrantsBillingAwardAccount)awards.get(i).getActiveAwardAccounts().get(0)).getAccountNumber());
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Federal Cash Disbursement " + (i + 1), this.contractsGrantsBillingUtilityService.formatForCurrency(this.getCashReceipts(awards.get(i))));
            totalCashControl = (KualiDecimal)totalCashControl.add((AbstractKualiDecimal)this.getCashReceipts(awards.get(i)));
            for (ContractsAndGrantsBillingAwardAccount awardAccount : awards.get(i).getActiveAwardAccounts()) {
                totalCashDisbursement = (KualiDecimal)totalCashDisbursement.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, systemOption.getActualFinancialBalanceTypeCd(), awards.get(i).getAwardBeginningDate()));
            }
        }
        ArrayList<KualiDecimal> list = new ArrayList<KualiDecimal>();
        list.add(totalCashControl);
        list.add(totalCashDisbursement);
        return list;
    }

    protected String getReportingPeriodEndDate(String reportingPeriod, String year) {
        Integer yearAsInt = Integer.parseInt(year);
        java.util.Date endDate = null;
        endDate = "q1".equals(reportingPeriod) ? ArConstants.BillingQuarterLastDays.FIRST_QUARTER.getDateForYear(yearAsInt) : ("q2".equals(reportingPeriod) || "Sa".equals(reportingPeriod) ? ArConstants.BillingQuarterLastDays.SECOND_QUARTER.getDateForYear(yearAsInt) : ("q3".equals(reportingPeriod) ? ArConstants.BillingQuarterLastDays.THIRD_QUARTER.getDateForYear(yearAsInt) : ArConstants.BillingQuarterLastDays.FOURTH_QUARTER.getDateForYear(yearAsInt)));
        return this.getDateTimeService().toDateString(endDate);
    }

    protected void stampPdfFormValues425(ContractsAndGrantsBillingAward award, String reportingPeriod, String year, OutputStream returnStream, Map<String, String> replacementList) {
        String reportTemplateName = "FEDERAL_FINANCIAL_FORM_425.pdf";
        try {
            String federalReportTemplatePath = this.configService.getPropertyValueAsString("externalizable.help.url");
            this.populateListByAward(award, reportingPeriod, year, replacementList);
            URL template = new URL(federalReportTemplatePath + reportTemplateName);
            byte[] pdfBytes = PdfFormFillerUtil.populateTemplate((InputStream)template.openStream(), replacementList);
            returnStream.write(pdfBytes);
        }
        catch (DocumentException | IOException ex) {
            throw new RuntimeException("Troubles stamping the old 425!", ex);
        }
    }

    protected void stampPdfFormValues425A(ContractsAndGrantsBillingAgency agency, String reportingPeriod, String year, OutputStream returnStream, Map<String, String> replacementList) {
        String federalReportTemplatePath = this.configService.getPropertyValueAsString("externalizable.help.url");
        try {
            String federal425ATemplateUrl = federalReportTemplatePath + "FEDERAL_FINANCIAL_FORM_425A" + ".pdf";
            String federal425TemplateUrl = federalReportTemplatePath + "FEDERAL_FINANCIAL_FORM_425" + ".pdf";
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("agencyNumber", agency.getAgencyNumber());
            fieldValues.put("active", Boolean.TRUE);
            List awards = this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObjectsList(ContractsAndGrantsBillingAward.class, fieldValues);
            Integer pageNumber = 1;
            Integer totalPages = awards.size() / 30 + 1;
            PdfCopyFields copy = new PdfCopyFields(returnStream);
            this.populateListByAgency(awards, reportingPeriod, year, agency);
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "totalPages", ObjectUtils.toString((Object)(totalPages + 1)));
            KualiDecimal sumCashControl = KualiDecimal.ZERO;
            KualiDecimal sumCumExp = KualiDecimal.ZERO;
            while (pageNumber <= totalPages) {
                ArrayList<ContractsAndGrantsBillingAward> awardsList = new ArrayList<ContractsAndGrantsBillingAward>();
                for (int i = (pageNumber - 1) * 30; i < pageNumber * 30; ++i) {
                    if (i >= awards.size()) continue;
                    awardsList.add((ContractsAndGrantsBillingAward)awards.get(i));
                }
                List<KualiDecimal> list = this.populateListByAgency(awardsList, reportingPeriod, year, agency);
                if (CollectionUtils.isNotEmpty(list)) {
                    sumCashControl = (KualiDecimal)sumCashControl.add((AbstractKualiDecimal)list.get(0));
                    if (list.size() > 1) {
                        sumCumExp = (KualiDecimal)sumCumExp.add((AbstractKualiDecimal)list.get(1));
                    }
                }
                this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "pageNumber", ObjectUtils.toString((Object)(pageNumber + 1)));
                if (pageNumber == totalPages) {
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Total", this.contractsGrantsBillingUtilityService.formatForCurrency(sumCashControl));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash Receipts", this.contractsGrantsBillingUtilityService.formatForCurrency(sumCashControl));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash Disbursements", this.contractsGrantsBillingUtilityService.formatForCurrency(sumCumExp));
                    this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "Cash on Hand", this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)sumCashControl.subtract((AbstractKualiDecimal)sumCumExp)));
                }
                copy.addDocument(new PdfReader(this.renameFieldsIn(federal425ATemplateUrl, replacementList)));
                Integer n = pageNumber;
                Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
            }
            this.contractsGrantsBillingUtilityService.putValueOrEmptyString(replacementList, "pageNumber", "1");
            copy.addDocument(new PdfReader(this.renameFieldsIn(federal425TemplateUrl, replacementList)));
            copy.close();
        }
        catch (DocumentException | IOException ex) {
            throw new RuntimeException("Tried to stamp the 425A, but couldn't do it.  Just...just couldn't do it.", ex);
        }
    }

    protected byte[] renameFieldsIn(String template, Map<String, String> list) throws IOException, DocumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfStamper stamper = new PdfStamper(new PdfReader(template), (OutputStream)baos);
        AcroFields fields = stamper.getAcroFields();
        for (String field : list.keySet()) {
            fields.setField(field, list.get(field));
        }
        stamper.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] combineInvoicePdfs(Collection<ContractsGrantsInvoiceDocument> list) throws DocumentException, IOException {
        Date runDate = new Date(new java.util.Date().getTime());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generateCombinedPdfForInvoices(list, baos);
        return baos.toByteArray();
    }

    @Override
    public byte[] combineInvoicePdfEnvelopes(Collection<ContractsGrantsInvoiceDocument> list) throws DocumentException, IOException {
        Date runDate = new Date(new java.util.Date().getTime());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generateCombinedPdfForEnvelopes(list, baos);
        return baos.toByteArray();
    }

    protected void generateCombinedPdfForInvoices(Collection<ContractsGrantsInvoiceDocument> list, OutputStream outputStream) throws DocumentException, IOException {
        PdfCopyFields copy = new PdfCopyFields(outputStream);
        boolean pageAdded = false;
        for (ContractsGrantsInvoiceDocument invoice : list) {
            List<InvoiceAddressDetail> invoiceAddressDetails = invoice.getInvoiceAddressDetails();
            for (InvoiceAddressDetail invoiceAddressDetail : invoiceAddressDetails) {
                if (!"MAIL".equals(invoiceAddressDetail.getInvoiceTransmissionMethodCode())) continue;
                Note note = this.noteService.getNoteByNoteId(Long.valueOf(invoiceAddressDetail.getNoteId()));
                Integer numberOfCopiesToPrint = invoiceAddressDetail.getCustomerAddress().getCustomerCopiesToPrint();
                if (org.kuali.kfs.krad.util.ObjectUtils.isNull((Object)numberOfCopiesToPrint)) {
                    numberOfCopiesToPrint = 1;
                }
                if (!org.kuali.kfs.krad.util.ObjectUtils.isNull((Object)note)) {
                    for (int i = 0; i < numberOfCopiesToPrint; ++i) {
                        if (!pageAdded) {
                            copy.open();
                        }
                        pageAdded = true;
                        copy.addDocument(new PdfReader(note.getAttachment().getAttachmentContents()));
                    }
                }
                invoiceAddressDetail.setInitialTransmissionDate(new Date(new java.util.Date().getTime()));
            }
            this.documentService.updateDocument((org.kuali.kfs.krad.document.Document)invoice);
        }
        if (pageAdded) {
            copy.close();
        }
    }

    protected void generateCombinedPdfForEnvelopes(Collection<ContractsGrantsInvoiceDocument> list, OutputStream outputStream) throws DocumentException, IOException {
        Document document = new Document(new Rectangle(650.0f, 320.0f));
        PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        boolean pageAdded = false;
        for (ContractsGrantsInvoiceDocument invoice : list) {
            for (InvoiceAddressDetail invoiceAddressDetail : invoice.getInvoiceAddressDetails()) {
                if (!"MAIL".equals(invoiceAddressDetail.getInvoiceTransmissionMethodCode())) continue;
                CustomerAddress address = invoiceAddressDetail.getCustomerAddress();
                Integer numberOfEnvelopesToPrint = address.getCustomerEnvelopesToPrintQuantity();
                if (org.kuali.kfs.krad.util.ObjectUtils.isNull((Object)numberOfEnvelopesToPrint)) {
                    numberOfEnvelopesToPrint = 1;
                }
                for (int i = 0; i < numberOfEnvelopesToPrint; ++i) {
                    if (!pageAdded) {
                        document.open();
                    }
                    pageAdded = true;
                    document.newPage();
                    Organization org = invoice.getInvoiceGeneralDetail().getAward().getPrimaryAwardOrganization().getOrganization();
                    Paragraph sentBy = this.generateAddressParagraph(org.getOrganizationName(), org.getOrganizationLine1Address(), org.getOrganizationLine2Address(), org.getOrganizationCityName(), org.getOrganizationStateCode(), org.getOrganizationZipCode(), ArConstants.PdfReportFonts.ENVELOPE_SMALL_FONT);
                    sentBy.setIndentationLeft(20.0f);
                    sentBy.setAlignment(0);
                    Paragraph sendTo = this.generateAddressParagraph(address.getCustomerAddressName(), address.getCustomerLine1StreetAddress(), address.getCustomerLine2StreetAddress(), address.getCustomerCityName(), address.getCustomerStateCode(), address.getCustomerZipCode(), ArConstants.PdfReportFonts.ENVELOPE_TITLE_FONT);
                    sendTo.setAlignment(1);
                    sendTo.add((Object)new Paragraph(" "));
                    document.add((Element)sentBy);
                    document.add((Element)sendTo);
                }
            }
        }
        if (pageAdded) {
            document.close();
        }
    }

    protected Paragraph generateAddressParagraph(String name, String line1Address, String line2Address, String cityName, String stateCode, String postalCode, Font font) {
        Paragraph addressParagraph = new Paragraph();
        addressParagraph.add((Object)new Paragraph(name, font));
        if (!StringUtils.isBlank((String)line1Address)) {
            addressParagraph.add((Object)new Paragraph(line1Address, font));
        }
        if (!StringUtils.isBlank((String)line2Address)) {
            addressParagraph.add((Object)new Paragraph(line2Address, font));
        }
        String string = "";
        if (!StringUtils.isBlank((String)cityName)) {
            string = string + cityName;
        }
        if (!StringUtils.isBlank((String)stateCode)) {
            string = string + ", " + stateCode;
        }
        if (!StringUtils.isBlank((String)postalCode)) {
            string = string + "-" + postalCode;
        }
        if (!StringUtils.isBlank((String)string)) {
            addressParagraph.add((Object)new Paragraph(string, font));
        }
        return addressParagraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertLetterOfCreditReviewToCSV(ContractsGrantsLetterOfCreditReviewDocument LOCDocument) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter(baos));
        try {
            csvWriter.writeNext(new String[]{this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "proposalNumber"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardDocumentNumber"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountDescription"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "chartOfAccountsCode"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountNumber"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "accountExpirationDate"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "awardBudgetAmount"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "claimOnCashBalance"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "amountToDraw"), this.getDataDictionaryService().getAttributeLabel(ContractsGrantsLetterOfCreditReviewDetail.class, "fundsNotDrawn")});
            if (CollectionUtils.isNotEmpty(LOCDocument.getHeaderReviewDetails()) && CollectionUtils.isNotEmpty(LOCDocument.getAccountReviewDetails())) {
                for (ContractsGrantsLetterOfCreditReviewDetail item : LOCDocument.getHeaderReviewDetails()) {
                    String proposalNumber = ObjectUtils.toString((Object)item.getProposalNumber());
                    String awardDocumentNumber = ObjectUtils.toString((Object)item.getAwardDocumentNumber());
                    for (ContractsGrantsLetterOfCreditReviewDetail newItem : LOCDocument.getAccountReviewDetails()) {
                        String accountExpirationDate;
                        String string = accountExpirationDate = org.kuali.kfs.krad.util.ObjectUtils.isNull((Object)newItem.getAccountExpirationDate()) ? "" : this.getDateTimeService().toDateString((java.util.Date)newItem.getAccountExpirationDate());
                        if (!ObjectUtils.equals((Object)item.getProposalNumber(), (Object)newItem.getProposalNumber())) continue;
                        csvWriter.writeNext(new String[]{proposalNumber, awardDocumentNumber, newItem.getAccountDescription(), newItem.getChartOfAccountsCode(), newItem.getAccountNumber(), accountExpirationDate, this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getAwardBudgetAmount()), this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getClaimOnCashBalance()), this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getAmountToDraw()), this.contractsGrantsBillingUtilityService.formatForCurrency(newItem.getFundsNotDrawn())});
                    }
                }
            }
        }
        finally {
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (IOException ex) {
                    csvWriter = null;
                    throw new RuntimeException("problem during ContractsGrantsInvoiceReportServiceImpl.generateCSVToExport()", ex);
                }
            }
        }
        return baos.toByteArray();
    }

    @Override
    public Collection<ContractsGrantsInvoiceLookupResult> getPopulatedContractsGrantsInvoiceLookupResults(Collection<ContractsAndGrantsBillingAward> awards) {
        ArrayList<ContractsGrantsInvoiceLookupResult> populatedContractsGrantsInvoiceLookupResults = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        if (awards.size() == 0) {
            return populatedContractsGrantsInvoiceLookupResults;
        }
        Iterator<Map.Entry<String, List<ContractsAndGrantsBillingAward>>> iter = this.getAwardByAgency(awards).entrySet().iterator();
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = null;
        while (iter.hasNext()) {
            Map.Entry<String, List<ContractsAndGrantsBillingAward>> entry = iter.next();
            List<ContractsAndGrantsBillingAward> list = entry.getValue();
            if (!CollectionUtils.isNotEmpty(list)) continue;
            ContractsAndGrantsBillingAgency agency = list.get(0).getAgency();
            contractsGrantsInvoiceLookupResult = new ContractsGrantsInvoiceLookupResult();
            if (org.kuali.kfs.krad.util.ObjectUtils.isNotNull((Object)agency)) {
                contractsGrantsInvoiceLookupResult.setAgencyNumber(agency.getAgencyNumber());
                contractsGrantsInvoiceLookupResult.setAgencyReportingName(agency.getReportingName());
                contractsGrantsInvoiceLookupResult.setAgencyFullName(agency.getFullName());
                contractsGrantsInvoiceLookupResult.setCustomerNumber(agency.getCustomerNumber());
            }
            contractsGrantsInvoiceLookupResult.setAwards(list);
            populatedContractsGrantsInvoiceLookupResults.add(contractsGrantsInvoiceLookupResult);
        }
        return populatedContractsGrantsInvoiceLookupResults;
    }

    protected Map<String, List<ContractsAndGrantsBillingAward>> getAwardByAgency(Collection<ContractsAndGrantsBillingAward> awards) {
        HashMap<String, List<ContractsAndGrantsBillingAward>> awardsByAgency = new HashMap<String, List<ContractsAndGrantsBillingAward>>();
        for (ContractsAndGrantsBillingAward award : awards) {
            if (StringUtils.isBlank((String)award.getBillingFrequencyCode()) || StringUtils.equalsIgnoreCase((String)award.getBillingFrequencyCode(), (String)"LOCB")) continue;
            String agencyNumber = award.getAgencyNumber();
            if (awardsByAgency.containsKey(agencyNumber)) {
                ((List)awardsByAgency.get(agencyNumber)).add(award);
                continue;
            }
            ArrayList<ContractsAndGrantsBillingAward> awardsByAgencyNumber = new ArrayList<ContractsAndGrantsBillingAward>();
            awardsByAgencyNumber.add(award);
            awardsByAgency.put(agencyNumber, awardsByAgencyNumber);
        }
        return awardsByAgency;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }

    @NonTransactional
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public ContractsGrantsBillingUtilityService getContractsGrantsBillingUtilityService() {
        return this.contractsGrantsBillingUtilityService;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

