/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.report.util.CustomerStatementResultHolder;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;
import org.kuali.kfs.module.ar.web.struts.CustomerStatementForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsWebUtils;

public class CustomerStatementAction
extends KualiAction {
    private static final Logger LOG = Logger.getLogger(CustomerStatementAction.class);

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerStatementForm csForm = (CustomerStatementForm)form;
        csForm.clear();
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String basePath = CustomerStatementAction.getApplicationBaseUrl();
        CustomerStatementForm csForm = (CustomerStatementForm)form;
        String chartCode = csForm.getChartCode();
        String orgCode = csForm.getOrgCode();
        String customerNumber = csForm.getCustomerNumber();
        String accountNumber = csForm.getAccountNumber();
        String statementFormat = csForm.getStatementFormat();
        String includeZeroBalanceCustomers = csForm.getIncludeZeroBalanceCustomers();
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)chartCode)) {
            params.put("chartCode", chartCode);
            request.setAttribute("chartCode", (Object)chartCode);
        }
        if (StringUtils.isNotBlank((String)orgCode)) {
            params.put("orgCode", orgCode);
            request.setAttribute("orgCode", (Object)orgCode);
        }
        if (StringUtils.isNotBlank((String)customerNumber)) {
            params.put("customerNumber", customerNumber);
            request.setAttribute("customerNumber", (Object)customerNumber);
        }
        if (StringUtils.isNotBlank((String)accountNumber)) {
            params.put("accountNumber", accountNumber);
            request.setAttribute("accountNumber", (Object)accountNumber);
        }
        if (StringUtils.isNotBlank((String)statementFormat)) {
            params.put("statementFormat", statementFormat);
        } else {
            params.put("statementFormat", "Summary");
        }
        if (StringUtils.isNotBlank((String)includeZeroBalanceCustomers)) {
            params.put("includeZeroBalanceCustomers", includeZeroBalanceCustomers);
        } else {
            params.put("includeZeroBalanceCustomers", "No");
        }
        String printPDFUrl = this.getUrlForPrintStatement(basePath, "printStatementPDF", params);
        String displayTabbedPageUrl = this.getUrlForPrintStatement(basePath, "start", params);
        request.setAttribute("printPDFUrl", (Object)printPDFUrl);
        request.setAttribute("displayTabbedPageUrl", (Object)displayTabbedPageUrl);
        request.setAttribute("printLabel", (Object)"Customer Statement");
        return mapping.findForward("arPrintPDF");
    }

    public ActionForward printStatementPDF(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerStatementForm csForm = (CustomerStatementForm)form;
        String chartCode = request.getParameter("chartCode");
        chartCode = chartCode == null ? "" : chartCode;
        String orgCode = request.getParameter("orgCode");
        orgCode = orgCode == null ? "" : orgCode;
        String customerNumber = request.getParameter("customerNumber");
        customerNumber = customerNumber == null ? "" : customerNumber;
        String accountNumber = request.getParameter("accountNumber");
        accountNumber = accountNumber == null ? "" : accountNumber;
        String statementFormat = request.getParameter("statementFormat");
        String includeZeroBalanceCustomers = request.getParameter("includeZeroBalanceCustomers");
        AccountsReceivableReportService reportService = (AccountsReceivableReportService)SpringContext.getBean(AccountsReceivableReportService.class);
        List<Object> reports = new ArrayList();
        StringBuilder fileName = new StringBuilder();
        String contentDisposition = "";
        if (!StringUtils.isBlank((String)chartCode) && !StringUtils.isBlank((String)orgCode)) {
            reports = reportService.generateStatementByBillingOrg(chartCode, orgCode, statementFormat, includeZeroBalanceCustomers);
            fileName.append(chartCode);
            fileName.append(orgCode);
        } else if (!StringUtils.isBlank((String)customerNumber)) {
            reports = reportService.generateStatementByCustomer(customerNumber.toUpperCase(), statementFormat, includeZeroBalanceCustomers);
            fileName.append(customerNumber);
        } else if (!StringUtils.isBlank((String)accountNumber)) {
            reports = reportService.generateStatementByAccount(accountNumber, statementFormat, includeZeroBalanceCustomers);
            fileName.append(accountNumber);
        }
        fileName.append("-StatementBatchPDFs.pdf");
        if (reports.size() != 0) {
            Object data;
            ArrayList<byte[]> contents = new ArrayList<byte[]>();
            for (CustomerStatementResultHolder customerStatementResultHolder : reports) {
                File file = customerStatementResultHolder.getFile();
                data = Files.readAllBytes(file.toPath());
                contents.add((byte[])data);
            }
            ByteArrayOutputStream baos = ((AccountsReceivablePdfHelperService)SpringContext.getBean(AccountsReceivablePdfHelperService.class)).buildPdfOutputStream(contents);
            KfsWebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString(), (boolean)Boolean.parseBoolean(request.getParameter("useJavascript")));
            if (statementFormat.equalsIgnoreCase("Detail")) {
                CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
                Iterator<Object> iterator = reports.iterator();
                while (iterator.hasNext()) {
                    data = (CustomerStatementResultHolder)iterator.next();
                    if (((CustomerStatementResultHolder)data).getInvoiceNumbers() != null) {
                        List<String> invoiceNumbers = ((CustomerStatementResultHolder)data).getInvoiceNumbers();
                        for (String number : invoiceNumbers) {
                            customerInvoiceDocumentService.updateReportedDate(number);
                        }
                    }
                    customerInvoiceDocumentService.updateReportedInvoiceInfo((CustomerStatementResultHolder)data);
                }
            }
            return null;
        }
        csForm.setMessage("No Reports Generated");
        return mapping.findForward("basic");
    }

    private String getUrlForPrintStatement(String basePath, String methodToCall, HashMap<String, String> params) {
        String baseUrl = basePath + "/" + "arCustomerStatement.do";
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.putAll((Map<?, ?>)params);
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }
}

