/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.report.service.FederalFinancialReportService;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;
import org.kuali.kfs.module.ar.web.struts.FederalFinancialReportForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsWebUtils;

public class FederalFinancialReportAction
extends KualiAction {
    private static Logger LOG = Logger.getLogger(FederalFinancialReportAction.class);
    private static volatile FederalFinancialReportService federalFinancialReportService;

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FederalFinancialReportForm ffrForm = (FederalFinancialReportForm)form;
        ffrForm.setReportingPeriod(null);
        ffrForm.setFiscalYear(null);
        ffrForm.setProposalNumber(null);
        return mapping.findForward("basic");
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FederalFinancialReportForm ffrForm = (FederalFinancialReportForm)form;
        String message = this.getFederalFinancialReportService().validate(ffrForm.getFederalForm(), ffrForm.getProposalNumber(), ffrForm.getFiscalYear(), ffrForm.getReportingPeriod(), ffrForm.getAgencyNumber());
        if (StringUtils.isEmpty((String)message)) {
            String basePath = FederalFinancialReportAction.getApplicationBaseUrl();
            String docId = ffrForm.getProposalNumber();
            String agencyNumber = ffrForm.getAgencyNumber();
            String formType = ffrForm.getFederalForm();
            String period = ffrForm.getReportingPeriod();
            String year = ffrForm.getFiscalYear();
            String printInvoicePDFUrl = this.getFederalFinancialReportService().getUrlForPrintInvoice(basePath, docId, period, year, agencyNumber, formType, "printInvoicePDF");
            String displayInvoiceTabbedPageUrl = this.getFederalFinancialReportService().getUrlForPrintInvoice(basePath, "", "", "", "", "", "start");
            request.setAttribute("printPDFUrl", (Object)printInvoicePDFUrl);
            request.setAttribute("displayTabbedPageUrl", (Object)displayInvoiceTabbedPageUrl);
            return mapping.findForward("arPrintPDF");
        }
        ffrForm.setError(message);
        return mapping.findForward("basic");
    }

    public ActionForward printInvoicePDF(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String proposalNumber = request.getParameter("docId");
        String period = request.getParameter("reportingPeriod");
        String year = request.getParameter("fiscalYear");
        String formType = request.getParameter("federalForm");
        String agencyNumber = request.getParameter("agencyNumber");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", proposalNumber);
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        map = new HashMap();
        map.put("agencyNumber", agencyNumber);
        ContractsAndGrantsBillingAgency agency = (ContractsAndGrantsBillingAgency)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAgency.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, map);
        if (ObjectUtils.isNotNull((Object)award) || ObjectUtils.isNotNull((Object)agency)) {
            ContractsGrantsInvoiceReportService reportService = (ContractsGrantsInvoiceReportService)SpringContext.getBean(ContractsGrantsInvoiceReportService.class);
            File report = reportService.generateFederalFinancialForm(award, period, year, formType, agency);
            byte[] content = Files.readAllBytes(report.toPath());
            ByteArrayOutputStream baos = ((AccountsReceivablePdfHelperService)SpringContext.getBean(AccountsReceivablePdfHelperService.class)).buildPdfOutputStream(content);
            StringBuilder fileName = new StringBuilder();
            fileName.append(formType);
            fileName.append("-");
            fileName.append(period);
            fileName.append("-");
            if (StringUtils.equals((String)formType, (String)"425")) {
                fileName.append(proposalNumber);
            } else {
                fileName.append(agencyNumber);
            }
            fileName.append(".pdf");
            KfsWebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString(), (boolean)Boolean.parseBoolean(request.getParameter("useJavascript")));
        }
        return null;
    }

    public FederalFinancialReportService getFederalFinancialReportService() {
        if (federalFinancialReportService == null) {
            federalFinancialReportService = (FederalFinancialReportService)SpringContext.getBean(FederalFinancialReportService.class);
        }
        return federalFinancialReportService;
    }
}

