/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AwardAccountObjectCodeTotalBilled;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsLetterOfCreditReviewDocumentService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ContractsGrantsLetterOfCreditReviewDocumentServiceImpl
implements ContractsGrantsLetterOfCreditReviewDocumentService {
    protected AwardAccountObjectCodeTotalBilledDao awardAccountObjectCodeTotalBilledDao;
    protected ContractsGrantsInvoiceCreateDocumentService contractsGrantsInvoiceCreateDocumentService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected KualiModuleService kualiModuleService;
    protected OptionsService optionsService;

    @Override
    public Map<String, KualiDecimal> calculateAwardAccountAmountsToDraw(ContractsAndGrantsBillingAward award, List<ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        HashMap<String, KualiDecimal> amounts = new HashMap<String, KualiDecimal>();
        List<AwardAccountObjectCodeTotalBilled> awardAccountTotalBilledAmounts = this.getAwardAccountObjectCodeTotalBilledDao().getAwardAccountObjectCodeTotalBuildByProposalNumberAndAccount(awardAccounts);
        SystemOptions systemOptions = this.optionsService.getCurrentYearOptions();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            KualiDecimal cumAmt = this.getContractsGrantsInvoiceDocumentService().getBudgetAndActualsForAwardAccount(awardAccount, systemOptions.getActualFinancialBalanceTypeCd(), award.getAwardBeginningDate());
            KualiDecimal billedAmount = KualiDecimal.ZERO;
            for (AwardAccountObjectCodeTotalBilled awardAccountTotalBilledAmount : awardAccountTotalBilledAmounts) {
                if (!StringUtils.equals((String)awardAccountTotalBilledAmount.getAccountNumber(), (String)awardAccount.getAccountNumber()) || !StringUtils.equals((String)awardAccountTotalBilledAmount.getChartOfAccountsCode(), (String)awardAccount.getChartOfAccountsCode()) || !awardAccountTotalBilledAmount.getProposalNumber().equals(awardAccount.getProposalNumber())) continue;
                billedAmount = (KualiDecimal)billedAmount.add((AbstractKualiDecimal)awardAccountTotalBilledAmount.getTotalBilled());
            }
            KualiDecimal amountToDraw = (KualiDecimal)cumAmt.subtract((AbstractKualiDecimal)billedAmount);
            amounts.put(this.getAwardAccountKey(awardAccount), amountToDraw);
        }
        return amounts;
    }

    @Override
    public String getAwardAccountKey(ContractsAndGrantsBillingAwardAccount awardAccount) {
        StringBuilder s = new StringBuilder();
        s.append(awardAccount.getChartOfAccountsCode());
        s.append('-');
        s.append(awardAccount.getAccountNumber());
        return s.toString();
    }

    @Override
    public KualiDecimal getAmountAvailableToDraw(KualiDecimal awardTotalAmount, List<ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        List<AwardAccountObjectCodeTotalBilled> awardAccountTotalBilledAmounts = this.getAwardAccountObjectCodeTotalBilledDao().getAwardAccountObjectCodeTotalBuildByProposalNumberAndAccount(awardAccounts);
        KualiDecimal billedAmount = KualiDecimal.ZERO;
        KualiDecimal amountAvailableToDraw = KualiDecimal.ZERO;
        for (AwardAccountObjectCodeTotalBilled awardAccountTotalBilledAmount : awardAccountTotalBilledAmounts) {
            billedAmount = (KualiDecimal)billedAmount.add((AbstractKualiDecimal)awardAccountTotalBilledAmount.getTotalBilled());
        }
        amountAvailableToDraw = (KualiDecimal)awardTotalAmount.subtract((AbstractKualiDecimal)billedAmount);
        return amountAvailableToDraw;
    }

    @Override
    public void generateContractsGrantsInvoiceDocuments(ContractsGrantsLetterOfCreditReviewDocument locReviewDoc) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        HashSet<Long> proposalNumberSet = new HashSet<Long>();
        for (ContractsGrantsLetterOfCreditReviewDetail detail : locReviewDoc.getHeaderReviewDetails()) {
            if (proposalNumberSet.contains(detail.getProposalNumber())) continue;
            awards.add(this.retrieveAward(detail.getProposalNumber()));
            proposalNumberSet.add(detail.getProposalNumber());
        }
        String locCreationType = !ObjectUtils.isNull((Object)locReviewDoc.getLetterOfCreditFundCode()) ? "LOC By Letter of Credit Fund" : "LOC By Letter of Credit Fund Group";
        this.getContractsGrantsInvoiceCreateDocumentService().createCGInvoiceDocumentsByAwards(awards, locReviewDoc.getAccountReviewDetails(), locCreationType);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.getContractsGrantsInvoiceCreateDocumentService().routeContractsGrantsInvoiceDocuments();
    }

    protected ContractsAndGrantsBillingAward retrieveAward(Long proposalNumber) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("proposalNumber", proposalNumber);
        ContractsAndGrantsBillingAward awd = (ContractsAndGrantsBillingAward)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        return awd;
    }

    @Override
    public List<ContractsAndGrantsBillingAward> getActiveAwardsByCriteria(Map<String, Object> criteria) {
        return this.getKualiModuleService().getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObjectsList(ContractsAndGrantsBillingAward.class, criteria);
    }

    public AwardAccountObjectCodeTotalBilledDao getAwardAccountObjectCodeTotalBilledDao() {
        return this.awardAccountObjectCodeTotalBilledDao;
    }

    public void setAwardAccountObjectCodeTotalBilledDao(AwardAccountObjectCodeTotalBilledDao awardAccountObjectCodeTotalBilledDao) {
        this.awardAccountObjectCodeTotalBilledDao = awardAccountObjectCodeTotalBilledDao;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public ContractsGrantsInvoiceCreateDocumentService getContractsGrantsInvoiceCreateDocumentService() {
        return this.contractsGrantsInvoiceCreateDocumentService;
    }

    public void setContractsGrantsInvoiceCreateDocumentService(ContractsGrantsInvoiceCreateDocumentService contractsGrantsInvoiceCreateDocumentService) {
        this.contractsGrantsInvoiceCreateDocumentService = contractsGrantsInvoiceCreateDocumentService;
    }
}

